#ifndef _RT3050_DSA_H__
#define _RT3050_DSA_H__

#include <linux/kernel.h>
#ifdef CONFIG_DEBUG_FS
#include <linux/debugfs.h>
#endif

#if CONFIG_PROC_FS
#include "procfs.h"
#endif

#include <linux/dsa/tag_rt3050_8021q.h>

#define RT3050_REG_ISR		0x00
#define RT3050_REG_IMR		0x04
#define RT3050_REG_FCT0		0x08
#define RT3050_REG_FCT1		0x0c
#define RT3050_REG_PFC0		0x10
#define RT3050_REG_PFC1		0x14
#define RT3050_REG_PFC2		0x18
#define RT3050_REG_GQS0		0x1c
#define RT3050_REG_ATS		0x24
#define RT3050_REG_ATS0		0x28
#define RT3050_REG_ATS1		0x2c
#define RT3050_REG_ATS2		0x30
#define RT3050_REG_WMAD0	0x34
#define RT3050_REG_WMAD1	0x38
#define RT3050_REG_WMAD2	0x3c
#define RT3050_REG_PVIDC(_n)	(0x40 + 4 * (_n))
#define RT3050_REG_VLANI(_n)	(0x50 + 4 * (_n))
#define RT3050_REG_VMSC(_n)	(0x70 + 4 * (_n))
#define RT3050_REG_POA		0x80
#define RT3050_REG_FPA		0x84
#define RT3050_REG_SOCPC	0x8c
#define RT3050_REG_POC0		0x90
#define RT3050_REG_POC1		0x94
#define RT3050_REG_POC2		0x98
#define RT3050_REG_SGC		0x9c
#define RT3050_REG_STRT		0xa0
#define RT3050_REG_PCR0		0xc0
#define RT3050_REG_PCR1		0xc4
#define RT3050_REG_FPA1		0xc8
#define RT3050_REG_FCT2		0xcc
#define RT3050_REG_SGC2		0xe4
#define RT3050_REG_LEDPX(_x) (0xa4 + (4 * (_x)))
#define RT3050_REG_P0LED		0xa4
#define RT3050_REG_P1LED		0xa8
#define RT3050_REG_P2LED		0xac
#define RT3050_REG_P3LED		0xb0
#define RT3050_REG_P4LED		0xb4
#define RT3050_REG_PPC		0xe0
#define RT3050_REG_PXPC(_x)		(0xe8 + (4 * (_x)))
#define RT3050_REG_P1PC		0xec
#define RT3050_REG_P2PC		0xf0
#define RT3050_REG_P3PC		0xf4
#define RT3050_REG_P4PC		0xf8
#define RT3050_REG_P5PC		0xfc

#define RT3050_LED_LINK		0
#define RT3050_LED_100M		1
#define RT3050_LED_DUPLEX		2
#define RT3050_LED_ACTIVITY		3
#define RT3050_LED_COLLISION	4
#define RT3050_LED_LINKACT		5
#define RT3050_LED_DUPLCOLL		6
#define RT3050_LED_10MACT		7
#define RT3050_LED_100MACT		8
/* Additional led states not in datasheet: */
#define RT3050_LED_BLINK		10
#define RT3050_LED_OFF		11
#define RT3050_LED_ON		12

#define RT3050_LINK_S		25
#define RT3050_DUPLEX_S		9
#define RT3050_SPD_S		0

#define RT3050_PCR0_WT_NWAY_DATA_S	16
#define RT3050_PCR0_WT_NWAY_DATA_M	0xFFFF
#define RT3050_PCR0_WT_PHY_CMD		BIT(13)
#define RT3050_PCR0_RD_PHY_CMD		BIT(14)
#define RT3050_PCR0_CPU_PHY_REG_S	8
#define RT3050_PCR0_CPU_PHY_REG_M	0x1F
#define RT3050_PCR0_PHY_ADDR_M		0x1F

#define RT3050_PCR1_WT_DONE		BIT(0)
#define RT3050_PCR1_RD_READY		BIT(1)

#define RT3050_ATS_TIMEOUT		(5 * HZ)
#define RT3050_PHY_TIMEOUT		(5 * HZ)

#define RT3050_PVIDC_PVID_M		0xfff
#define RT3050_PVIDC_PVID_S		12

#define RT3050_VLANI_VID_M		0xfff
#define RT3050_VLANI_VID_S		12

#define RT3050_VMSC_MSC_M		0xff
#define RT3050_VMSC_MSC_S		8

#define RT3050_SOCPC_DISUN2CPU_S	0
#define RT3050_SOCPC_DISMC2CPU_S	8
#define RT3050_SOCPC_DISBC2CPU_S	16
#define RT3050_SOCPC_CRC_PADDING	BIT(25)
#define RT3050_SOCPC_DISUN2CPU(_port)	(BIT(_port) << RT3050_SOCPC_DISUN2CPU_S)
#define RT3050_SOCPC_DISMC2CPU(_port)	(BIT(_port) << RT3050_SOCPC_DISMC2CPU_S)
#define RT3050_SOCPC_DISBC2CPU(_port)	(BIT(_port) << RT3050_SOCPC_DISBC2CPU_S)

#define RT3050_POC0_EN_BP_S		0
#define RT3050_POC0_EN_FC_S		8
#define RT3050_POC0_DIS_RMC2CPU_S	16
#define RT3050_POC0_DIS_PORT_M		0x7f
#define RT3050_POC0_DIS_PORT_S		23

#define RT3050_POC2_UNTAG_EN_M		0xff
#define RT3050_POC2_UNTAG_EN_S		0
#define RT3050_POC2_ENAGING_S		8
#define RT3050_POC2_DIS_UC_PAUSE_S	16

#define RT3050_SGC2_DOUBLE_TAG_M	0x7f
#define RT3050_SGC2_DOUBLE_TAG_EXTPORTS_M	0x1f
#define RT3050_SGC2_DOUBLE_TAG_S	0
#define RT3050_SGC2_LAN_PMAP_M		0x3f
#define RT3050_SGC2_LAN_PMAP_S		24
#define RT3050_SGC2_SLOT_4TO1_S		8
#define RT3050_SGC2_SLOT_4TO1_M		0x1
#define RT3050_SGC2_ARBITER_GPT_EN_S	9
#define RT3050_SGC2_ARBITER_GPT_EN_M	0x1
#define RT3050_SGC2_CPU_TPID_EN_S	10
#define RT3050_SGC2_CPU_TPID_EN_M	0x1
#define RT3050_SGC2_ARBITER_LAN_EN_S	11
#define RT3050_SGC2_ARBITER_LAN_EN_M	0x1

#define RT3050_PFC1_EN_VLAN_S		16
#define RT3050_PFC1_EN_TOS_S		24

#define RT3050_VLAN_NONE		0xfff

#define RT3050_SGC_BC_STORM_M		0x3
#define RT3050_SGC_BC_STORM_S		4
#define RT3050_SGC_LED_FREQ_M		0x3
#define RT3050_SGC_LED_FREQ_S		23

#define RT3050_POA_LINK_M		0x1f
#define RT3050_POA_LINK_S		25
#define RT3050_POA_XFC_M		0x1f
#define RT3050_POA_XFC_S		16
#define RT3050_POA_DUPLEX_M		0x1f
#define RT3050_POA_DUPLEX_S		9
#define RT3050_POA_SPEED_M		0x1f
#define RT3050_POA_SPEED_S		0
#define RT3050_POA_LINK_CPU_M(_port)	(_port == RT3050_PORT6 ? 0x40 : 0x20)
#define RT3050_POA_XFC_CPU_M(_port)	(_port == RT3050_PORT6 ? 0x180 : 0x60)
#define RT3050_POA_DUPLEX_CPU_M(_port)	(_port == RT3050_PORT6 ? 0x40 : 0x20)
#define RT3050_POA_SPEED_CPU_M(_port)	(_port == RT3050_PORT6 ? 0x180 : 0x60)

#define RT3050_POC1_SA_SECURED_PORT_S	0
#define RT3050_POC1_SA_SECURED_PORT_M	0x7f
#define RT3050_POC1_DIS_LRNING_S	8
#define RT3050_POC1_DIS_LRNING_M	0x7f
#define RT3050_POC1_BLOCKING_STATE_S	16
#define RT3050_POC1_BLOCKING_STATE_M	0x7f
#define RT3050_POC1_DISIPMC2CPU_S	23
#define RT3050_POC1_DISIPMC2CPU_M	0x7f

#define RT3050_STP_SECURED_PORT(_port)	((BIT(_port) & RT3050_POC1_SA_SECURED_PORT_M) << RT3050_POC1_SA_SECURED_PORT_S)
#define RT3050_STP_DIS_LEARN(_port)	((BIT(_port) & RT3050_POC1_DIS_LRNING_M) << RT3050_POC1_DIS_LRNING_S)
#define RT3050_STP_STATE_BLOCK(_port)	((BIT(_port) & RT3050_POC1_BLOCKING_STATE_M) << RT3050_POC1_BLOCKING_STATE_S)
#define RT3050_STP_STATE_LEARN(_port)	((BIT(_port) & RT3050_POC1_BLOCKING_STATE_M) << RT3050_POC1_BLOCKING_STATE_S |	\
					(BIT(_port) & RT3050_POC1_DIS_LRNING_M) << RT3050_POC1_DIS_LRNING_S)

#define RT3050_PORT_ST_CHG		BIT(26)

#define RT3050_PORTS_NONE		0

#define RT3050_PMAP_LLLLLL		0x3f
#define RT3050_PMAP_LLLLWL		0x2f
#define RT3050_PMAP_WLLLLL		0x3e

#define RT3050_PORTS_INTERNAL		(BIT(RT3050_PORT0) | BIT(RT3050_PORT1) |	\
					 BIT(RT3050_PORT2) | BIT(RT3050_PORT3) |	\
					 BIT(RT3050_PORT4))
#define RT3050_PORTS_NOCPU		(RT3050_PORTS_INTERNAL | BIT(RT3050_PORT5))
#define RT3050_PORTS_CPU		BIT(RT3050_PORT6)
#define RT3050_PORTS_ALL		(RT3050_PORTS_NOCPU | RT3050_PORTS_CPU)

#define RT3050_NUM_VLANS		16
#define RT3050_NUM_VIDS			4096
#define RT3050_NUM_PORTS		7
#define RT3050_NUM_LANWAN		6
#define RT3050_NUM_LEDS			5
#define RT3050_NUM_PHY_PORTS		5
#define RT3050_NUM_QUEUES		4
#define RT3050_NUM_TAGS			8

#define RT5350_ESW_REG_PXTPC(_x)	(0x150 + (4 * (_x)))
#define RT5350_EWS_REG_LED_CONTROL	0x168

#define RT3050_SGC_PKT_MAX_LEN_S	6
#define RT3050_SGC_PKT_MAX_LEN_M	0x3
#define RT3050_SGC_AGING_INTERVAL_S	0
#define RT3050_SGC_AGING_INTERVAL_M	0xf
#define RT3050_SGC_PKT_MAX_LEN_S	6
#define RT3050_SGC_PKT_MAX_LEN_M	0x3
#define RT3050_SGC_ADDRESS_HASH_ALG_S	9
#define RT3050_SGC_ADDRESS_HASH_ALG_M	0x3
#define RT3050_SGC_BP_JAM_CNT_S		12
#define RT3050_SGC_BP_JAM_CNT_M		0xf
#define RT3050_SGC_BP_MODE_S		18
#define RT3050_SGC_BP_MODE_M		0x3
#define RT3050_SGC_RMC_RULE_S		25
#define RT3050_SGC_RMC_RULE_M		0x3
#define RT3050_SGC_IP_MULT_RULE_S	27
#define RT3050_SGC_IP_MULT_RULE_M	0x3

#define RT3050_ISR_PORT_ST_CHG_M	BIT(26)

#define RT3050_FPA_FORCE_SPD_S		0
#define RT3050_FPA_FORCE_SPD_M		0x1f
#define RT3050_FPA_FORCE_DPX_S		8
#define RT3050_FPA_FORCE_DPX_M		0x1f
#define RT3050_FPA_FORCE_XFC_S		16
#define RT3050_FPA_FORCE_XFC_M		0x1f
#define RT3050_FPA_FORCE_LINK_S		22
#define RT3050_FPA_FORCE_LINK_M		0x1f
#define RT3050_FPA_FORCE_MODE_S		27
#define RT3050_FPA_FORCE_MODE_M		0x1f

#define RT3050_FPA1_FORCE_RGMII_SPD_S	0
#define RT3050_FPA1_FORCE_RGMII_SPD_M(_port)	(_port == RT3050_PORT6 ? 0xc : 0x3)
#define RT3050_FPA1_FORCE_RGMII_DPX_S	4
#define RT3050_FPA1_FORCE_RGMII_DPX_M(_port)	(_port == RT3050_PORT6 ? 0x2 : 0x1)
#define RT3050_FPA1_FORCE_RGMII_XFC_S	6
#define RT3050_FPA1_FORCE_RGMII_XFC_M(_port)	(_port == RT3050_PORT6 ? 0xc : 0x3)
#define RT3050_FPA1_FORCE_RGMII_FORCE_S	10
#define RT3050_FPA1_FORCE_RGMII_FORCE_M(_port)	(_port == RT3050_PORT6 ? 0x2 : 0x1)
#define RT3050_FPA1_FORCE_RGMII_LINK_S	12
#define RT3050_FPA1_FORCE_RGMII_LINK_M(_port)	(_port == RT3050_PORT6 ? 0x2 : 0x1)

#define RT3050_WMAD0_AT_CFG_IDLE_S	19
#define RT3050_WMAD0_AT_CFG_IDLE_M	0x1
#define RT3050_WMAD0_W_PORT_MAP_S	12
#define RT3050_WMAD0_W_PORT_MAP_M	0x7f
#define RT3050_WMAD0_W_INDEX_S		7
#define RT3050_WMAD0_W_INDEX_M		0xf
#define RT3050_WMAD0_W_AGE_FIELD_S	4
#define RT3050_WMAD0_W_AGE_FIELD_M	0x7
#define RT3050_WMAD0_SA_FILTER_S	3
#define RT3050_WMAD0_SA_FILTER_M	0x1
#define RT3050_WMAD0_W_MC_INGRESS_S	2
#define RT3050_WMAD0_W_MC_INGRESS_M	0x1
#define RT3050_WMAD0_W_MAC_DONE_S	1
#define RT3050_WMAD0_W_MAC_DONE_M	0x1
#define RT3050_WMAD0_W_MAC_CMD_S	0
#define RT3050_WMAD0_W_MAC_CMD_M	0x1

#define RT3050_ATS_BEGIN_SEARCH_ADDR	BIT(0)
#define RT3050_ATS_SEARCH_NXT_ADDR	BIT(1)
#define RT3050_ATS_AT_LKUP_IDLE		BIT(2)
#define RT3050_ATS0_R_PORT_MAP_S	12
#define RT3050_ATS0_R_PORT_MAP_M	0x7f
#define RT3050_ATS0_R_VLD_S		7
#define RT3050_ATS0_R_VLD_M		0xf
#define RT3050_ATS0_R_AGE_FIELD_S	4
#define RT3050_ATS0_R_AGE_FIELD_M	0x7
#define RT3050_ATS0_R_MC_INGRESS_S	2
#define RT3050_ATS0_R_MC_INGRESS_M	0x1
#define RT3050_ATS0_AT_TABLE_END_S	1
#define RT3050_ATS0_AT_TABLE_END_M	0x1
#define RT3050_ATS0_SEARCH_RDY_S	0
#define RT3050_ATS0_SEARCH_RDY_M	0x1

#define RT3050_FCT0_FC_RLS_TH_S	24
#define RT3050_FCT0_FC_SET_TH_S	16
#define RT3050_FCT0_DROP_RLS_TH_S	8
#define RT3050_FCT0_DROP_SET_TH_S	0
#define RT3050_FCT1_PORT_TH_S	0
#define RT3050_FCT_M	0xff

#define RT3050_PFC0_MTCC_LMT_S	24
#define RT3050_PFC0_MTCC_LMT_M	0xf
#define RT3050_PFC0_TURN_OFF_FC_S	16
#define RT3050_PFC0_TURN_OFF_FC_M	0x7f
#define RT3050_PFC0_VO_NUM_S	12
#define RT3050_PFC0_CL_NUM_S	8
#define RT3050_PFC0_BE_NUM_S	4
#define RT3050_PFC0_BK_NUM_S	0
#define RT3050_PFC0_NUM_M	0xf
#define RT3050_PFC0_QUEUE_NUM_S(_queue)	((_queue) << 2)

#define RT3050_PFC1_EN_TOS_S	24
#define RT3050_PFC1_EN_TOS_M	0x7f
#define RT3050_PFC1_EN_VLAN_S	16
#define RT3050_PFC1_EN_VLAN_M	0x7f
#define RT3050_PFC1_PORT_PRI_S(_port)	((_port) << 1)
#define RT3050_PFC1_PORT_PRI_M	0x3
#define RT3050_PFC1_PORT_PRI_VAL_SET(_port, _q)	((_q & RT3050_PFC1_PORT_PRI_M) << RT3050_PFC1_PORT_PRI_S(_port))
#define RT3050_PFC1_PORT_PRI_VAL_GET(_port, _reg)	((_reg >> RT3050_PFC1_PORT_PRI_S(_port)) & RT3050_PFC1_PORT_PRI_M)
#define RT3050_PFC1_PRIORITY_OPTION_S	15
#define RT3050_PFC1_PRIORITY_OPTION_M	0x1

#define RT3050_PFC2_PRI_TH_VO_S	24
#define RT3050_PFC2_PRI_TH_CL_S	16
#define RT3050_PFC2_PRI_TH_BE_S	8
#define RT3050_PFC2_PRI_TH_BK_S	0
#define RT3050_PFC2_PRI_TH_M	0xff
#define RT3050_PFC2_QUEUE_PRI_TH_S(_queue)	((_queue) << 3)

#define RT3050_GQS0_TAG_S(_tag)	(16 + ((_tag) << 1))
#define RT3050_GQS0_TAG_M	0x3

#define RT3050_PVIDC3_QUE_PRIT_M(_queue)	(0x7 << (((_queue) << 2) + 16))
#define RT3050_PVIDC3_QUE_PRIT_VAL_SET(_queue, _pcp)	(((_pcp) & 0x7) << (((_queue) << 2) + 16))
#define RT3050_PVIDC3_QUE_PRIT_VAL_GET(_queue, _reg)	(((_reg) >> (((_queue) << 2) + 16)) & 0x7)

#define RT3050_LEDPX_M	0xf

struct rt3050_stat_entity {
	const char* name;
	u32 reg;
	bool up;
};

#define RT3050_REG_COUNTER_PER_PORT(reg, port)	(reg + ((port) << 2))
#define RT3050_COUNTER_M			0xffff
#define RT3050_COUNTER_S			16

#define	RT3050_MAX_TAGS		8

#define	RT3050_QUEUE_BACKGROUND	0
#define	RT3050_QUEUE_BESTEFFORT	1
#define	RT3050_QUEUE_CONTROL	2
#define	RT3050_QUEUE_VOICE	3

enum {
	/* Global attributes. */
	RT3050_ATTR_ENABLE_VLAN,
	RT3050_ATTR_ALT_VLAN_DISABLE,
	RT3050_ATTR_BC_STATUS,
	RT3050_ATTR_LED_FREQ,
	/* Port attributes. */
	RT3050_ATTR_PORT_DISABLE,
	RT3050_ATTR_PORT_DOUBLETAG,
	RT3050_ATTR_PORT_UNTAG,
	RT3050_ATTR_PORT_LED,
	RT3050_ATTR_PORT_LAN,
	RT3050_ATTR_PORT_RECV_BAD,
	RT3050_ATTR_PORT_RECV_GOOD,
	RT5350_ESW_ATTR_PORT_TR_BAD,
	RT5350_ESW_ATTR_PORT_TR_GOOD,
};


struct rt3050_sa_secured_mac_addr_entry {
	struct list_head	list;
	u8			mac[ETH_ALEN];
};
/* 
 Structre to match bridge related VLAN features.
 Keep bridge VLAN entry per port.
*/
struct rt3050_br_port_vlan_entry {
	struct list_head	list;
	u16			pvid;
};

struct rt3050_port {
	bool			disabled;
	bool			up;
	bool			doubletag;
	bool			untag;
	bool			filtering;
	bool			forwarding;
	u8			led;
	u16			pvid;
	struct list_head	br_vlan_list;
	struct list_head	sa_secured_mac_addr_list;
};

struct rt3050_vlan {
	u32	ports;
	u16	vid;
	void	*bridge_ptr;
};

struct rt3050_priv;

struct rt3050_pcs {
	struct phylink_pcs	pcs;
	struct rt3050_priv	*priv;
	int			port;
};

struct rt3050_priv {
	struct device		*dev;
	struct dsa_switch	*ds;
	void __iomem		*base;
	u32			irq;
	struct irq_domain	*irq_domain;

	struct mutex		mtx;
	/* Protects against concurrent register r/w operations. */
	spinlock_t		reg_rw_lock;
	int			cpu_port;

	u8			port_map;
	u32			reg_initval_fct2;
	u32			reg_initval_fpa2;
	u32			reg_led_polarity;
	u32			reg_led_source;

	bool			global_vlan_enable;
	bool			alt_vlan_disable;
	bool			do_bridge_offloading;
	u32			bc_storm_protect;
	u32			led_frequency;
	struct rt3050_vlan	vlans[RT3050_NUM_VLANS];
	struct rt3050_port	ports[RT3050_NUM_PORTS];
	struct rt3050_pcs	pcs[RT3050_NUM_PORTS];
	struct reset_control	*rst_esw;
	struct reset_control	*rst_ephy;
#ifdef CONFIG_NET_DSA_RT3050_DEBUGFS
	struct dentry		*dbgfs_dir;
#endif
#if CONFIG_PROC_FS
	struct proc_dir_entry	*procentry;
#endif
};

#define	RT3050_DRIVER_NAME	"rt3050-dsa-switch"
#define	RT3050_COUNTERS		6

extern const struct dsa_switch_ops rt3050_switch_ops;

static inline void rt3050_w32(struct rt3050_priv *priv, u32 val, u32 reg)
{
	__raw_writel(val, priv->base + reg);
}

static inline u32 rt3050_r32(struct rt3050_priv *priv, u32 reg)
{
	return __raw_readl(priv->base + reg);
}

static inline void rt3050_rmw_raw(struct rt3050_priv *priv, u32 reg,
			       u32 mask, u32 val)
{
	u32 t = __raw_readl(priv->base + reg) & ~mask;
	__raw_writel(t | val, priv->base + reg);
}

static inline struct rt3050_br_port_vlan_entry * rt3050_lookup_port_bridge_vlan(struct rt3050_port *port, u16 vid)
{
	struct rt3050_br_port_vlan_entry *entry;

	list_for_each_entry(entry, &port->br_vlan_list, list) {
		if (entry->pvid == vid)
			return entry;
	}
	return NULL;
}

int rt3050_reset_switch(struct rt3050_priv *priv);
irqreturn_t rt3050_irq_handler(int irq, void *_rt3050);
void rt3050_enable_irq(struct rt3050_priv *priv);
void rt3050_disable_irq(struct rt3050_priv *priv);
void rt3050_free_irq(struct rt3050_priv *priv);
void rt3050_cpu_port_config(struct rt3050_priv *priv, bool up);
void rt3050_set_port_disable(struct rt3050_priv *priv, u32 disable_mask);
u32 rt3050_get_port_disable(struct rt3050_priv *priv);
u32 rt3050_get_vmsc(struct rt3050_priv *priv, u16 vlan);
void rt3050_set_vmsc(struct rt3050_priv *priv, u16 vlan, u32 msc);
void rt3050_rmw(struct rt3050_priv *priv, u32 reg, u32 mask, u32 val);
int rt3050_mii_write(struct rt3050_priv *priv, int phy_addr,
	int phy_register, u32 write_data);
int rt3050_mii_read(struct rt3050_priv *priv, int phy_addr,
	int phy_register);
u16 rt3050_get_vlan_id(struct rt3050_priv *priv, u16 vlan);
void rt3050_set_vlan_id(struct rt3050_priv *priv, u16 vlan, u16 vid);
u16 rt3050_get_pvid(struct rt3050_priv *priv, int port);
u32 rt3050_get_untagged_port(struct rt3050_priv *priv);
void rt3050_set_port_untagged(struct rt3050_priv *priv, int port);
void rt3050_set_port_tagged(struct rt3050_priv *priv, int port);
void rt3050_add_vlan_to_port(struct rt3050_priv *priv, u16 vlan, int port);
void rt3050_del_vlan_from_port(struct rt3050_priv *priv, u16 vlan, int port);
void rt3050_set_pvid(struct rt3050_priv *priv, int port, u16 pvid);
void rt3050_get_phylink_port_state(struct rt3050_priv *priv, int port, struct phylink_link_state *state);
int rt3050_port_fdb_dump(struct dsa_switch *ds, int port,
	dsa_fdb_dump_cb_t *cb, void *data);

void rt3050_set_queue_weight(struct rt3050_priv *priv, int queue, u32 weight);
u32 rt3050_get_queue_weight(struct rt3050_priv *priv, int queue);
void rt3050_set_queue_threshold(struct rt3050_priv *priv, int queue, u32 threshold);
u32 rt3050_get_queue_threshold(struct rt3050_priv *priv, int queue);
void rt3050_set_queue_priority_tag(struct rt3050_priv *priv, int queue, u32 priority_tag);
u32 rt3050_get_queue_priority_tag(struct rt3050_priv *priv, int queue);
void rt3050_set_queue_tags(struct rt3050_priv *priv, int queue, u32 *tags, int count);
u32* rt3050_get_queue_tags(struct rt3050_priv *priv, int queue, u32 *tags, int *count);
void rt3050_set_queue_ports(struct rt3050_priv *priv, int queue, u32 *ports, int count);
u32* rt3050_get_queue_ports(struct rt3050_priv *priv, int queue, u32 *ports, int *count);
void rt3050_set_port_threshold(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_threshold(struct rt3050_priv *priv, int port);
void rt3050_set_port_turnoff(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_turnoff(struct rt3050_priv *priv, int port);
void rt3050_set_port_tos(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_tos(struct rt3050_priv *priv, int port);
void rt3050_set_port_vlan(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_vlan(struct rt3050_priv *priv, int port);
void rt3050_set_port_priority(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_priority(struct rt3050_priv *priv, int port);
void rt3050_set_pref_queue(struct rt3050_priv *priv, u32 pref);
u32 rt3050_get_pref_queue(struct rt3050_priv *priv);
void rt3050_set_fct0_reg(struct rt3050_priv *priv, int start, u32 value);
u32 rt3050_get_fct0_reg(struct rt3050_priv *priv, int start);
void rt3050_set_bc_storm_control(struct rt3050_priv *priv, u32 value);
u32 rt3050_get_bc_storm_control(struct rt3050_priv *priv);
int rt3050_port_xdb_op(struct rt3050_priv *priv, int port, 
	const unsigned char *addr, u16 vid, bool add, bool mc);
void rt3050_set_port_secured_mode(struct rt3050_priv *priv, int port, struct rt3050_sa_secured_mac_addr_entry *values, int count);
u32 rt3050_get_port_secured_mode(struct rt3050_priv *priv, int port, struct rt3050_sa_secured_mac_addr_entry *values, int *count);
void rt3050_set_port_led_state(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_led_state(struct rt3050_priv *priv, int port);
void rt3050_set_port_doubletag(struct rt3050_priv *priv, int port, u32 value);
u32 rt3050_get_port_doubletag(struct rt3050_priv *priv, int port);

#ifdef CONFIG_NET_DSA_RT3050_DEBUGFS
void rt3050_dbgfs_init(struct rt3050_priv *priv);
void rt3050_dbgfs_cleanup(struct rt3050_priv *priv);
#endif
#endif /* __RT3050_H */
