# Режимы работы DSA-коммутатора

Каждый порт коммутатора в DSA-режиме представляет из себя сетевой интерфейс ядра Линукс. Далее такой интерфейс мы будем называть "псевдоинтерфейс".
Один портов коммутатора используется для соединения коммутатора с сетевым интерфейсом SoC. Это, так называемый, процессорный порт.

## Псевдоинтерфейс процессорного порта

Во многих вариантах ядра Линукс, данному псевдоинтерфейсу соответствует имя eth0. Размер MTU для данного интерфейса должен быть 1504 байт. Запрещается включать этот интерфейс в сетевые мосты, агрегаты и т.п; задействовать его в маршрутизации, назначать на него IP-адреса. 
**См. пример DTS-файла.**

## Псевдоинтерфейсы пользовательских портов

Имена данных интерфейсов задаются через DTS-файл, свойство label.  Максимальный размер MTU - 1500 байт. MAC-адрес может быть назначен через DTS-файл.
**См. пример DTS-файла.**

Псевдоинтерфейсы могут использоваться для маршрутизации, агрегации, объединения в мосты. На них могут назначаться IP-адреса.

### Работа псевдоинтерфейсов в режиме маршрутизации

Обработка пакетов полностью программная. Все действия выполняются на ЦПУ. Счетчики кадров и байт на интерфейсах обновляются корректно.

### Работа псевдоинтерфейсов в режиме агрегации

Обработка пакетов полностью программная. Все действия выполняются на ЦПУ. Счетчики кадров и байт на интерфейсах обновляются корректно.

### Работа псевдоинтерфейсов в режиме моста

Драйвер коммутатора поддерживает включение псевдоинтерфейсов в сетевые мосты, вплоть до включения каждого псевдоинтерфейса в отдельный сетевой мост.

#### Режим работы сетевого моста 

Пересылка трафика на порты сетевого моста, не являющиеся физическими портами коммутатора выполняется с задействованием ресурсов ЦПУ (программно).
Далее мы опишем режимы работы коммутатора при пересылке кадров между двумя пользовательскими портами в пределах одного сетевого моста.

Мосты в ОС Линукс могут работать как с выключенным (режим по-умолчанию), так и с включенным режимом VLAN-filtering. Рассмотрим их раздельно.

##### Режим по-умолчанию (выключенный VLAN-filtering)

Реализованы два режима работы.
- Программный. Все действия выполняются на ЦПУ. Счетчики кадров и байт на интерфейсах обновляются корректно.
- Аппаратный режим. Пересылка выполняется средствами коммутатора. ЦПУ не загружается. Счетчики кадров и байт на интерфейсах обновляются некорректно. Внутренние счетчики коммутатора (доступные через ethtool) обновляются корректно. Режим включается опцией bridge_offloading в DTS-файле.
**См. пример DTS-файла.**

##### Режим включенного VLAN-filtering

Обработка пакетов полностью программная. Все действия выполняются на ЦПУ. Счетчики кадров и байт на интерфейсах обновляются корректно. Опция bridge_offloading на данный режим влияния не оказывает.

**Невозможно реализовать аппаратно ввиду ограничений платформы: "Увиденные MAC-адреса заносятся только в VLAN соответствующий PVID порта. Возможность операций только с 16 внутренними VLAN.**
