# Общие сведения

Для контроля и (или) настройки некоторых аспектов работы коммутатора, для которых нет стандарных интерфейсов в рамках netlink, dsa и switchdev использована файловая система procfs.
Для реализации интерфейса к функциям коммутатора, используются файлы, сгруппированные в каталоги на основании функционального (настройка QoS) или объектного характера (управление параметрами).

Все файлы допускают операции чтения и записи данных. Каталоги служат исключительно цели упорядочения структуры файлов.
Имена файлов и каталогов приведены в логическое соответствие с их назначением.

# форматы данных

При чтении / записи информации в файлы используется строковое представление данных.

## Булеввый формат данных

Значения '0' и '1'. Допустимо использование типа: echo 0 > /proc/switch/qos/quques/3/enable_flow_control_on_threshold или echo '1' > /proc/switch/qos/quques/3/enable_flow_control_on_threshold

## Формат данных типа 'Строка'

Значениями являются предопреленные строковые констатнты. Например, 'tos', 'pcp', 'soft' и т.п.
Допустимо использование типа: echo 'tos' > /proc/switch/qos/preference_to_select_queue

## Формат данных типа 'Число'

Значениями являются целые неотрицательные числа со значениями от 0 до 0xFFFF. При чтении / записи из файла, значение выдаётся в 10- или 16-ричной системе счисления. При записи следует использовать модификатор '0x' для однозначного указания принадлежности числа к 16-ричной системе.
Допустимо использование типа: echo 8 > /proc/switch/qos/queueus/0/weight
Конкретные допустимые значения параметров (в том числе минимальное и максимальное) зависит от используемого коммутатора и должно быть уточнено в документации.

## Формат данных типа 'Карта байтов'

Значениями являются последовательность целых неотрицательные числа со значениями от 0 до 0xF. Числа разедляются пробелом.
Для чисел используется исключительно 16-ричная система счисления.
Допустимо использование типа: echo '0 1 2 3 4' > /proc/switch/qos/queueus/0/portmap
Максимальное число параметров в карте бывает как фиксированным, например, число тегов pcp и tos равно 8-ми; так и может определяться конструкцией конкретного коммутатора (например, число портов и очередей).

# Каталоги

- *switch* - корневой каталог для управления коммутатором через procfs.
	- *queues* - каталог, содержащий подкаталоги номеров очередей (0 - 3), позволяющие производить настройку отдельной очереди. Очередь 3 имеет самый высокий приоритет.
		- *qos* - каталог для настройки параметров качества обслуживания для очередей (QoS) на коммутаторе.
	- *ports* - каталог, содержащий подкаталоги с номерами портов (0 - 6), позволяющие настроить параметры QoS на конкретного порта.
		- *qos* - каталог для настройки параметров качества обслуживания для портов (QoS) на коммутаторе.
		- *security* - каталог для настройки параметров безопасности на коммутаторе.
		- *led* - каталог для настройки работы светодиодов на коммутаторе.
		- *mgmt* - каталог для настройки поведения портов коммутатора для некоторых случаев эксплуатации.
	- *mgmt* - каталог для настройки поведения коммутатора для некоторых случаев эксплуатации, например, возникновения широковещательного шторма.
		 - *thresholds* - каталог для настройки пороговых значений Flow Control.



## Каталоги внутри каталога *queues*

- Содержит файл с именем *preference_to_select_queue* для определения приоритетного варианта выбора очереди.
**Тип данных:** строка.
**Возможные значения при чтении:** 'tos' (установлен порядок tos->pcp->port) или 'pcp' (установлен порядок pcp->tos->port).
**Возможные значения при записи:** 'tos' (установить порядок tos->pcp->port) или 'pcp' (утсановить порядок pcp->tos->port).

Внутри каталога queues присутствуют подкаталоги с номерами очередей. Номера очередей упорядочены по приоритету. Очередь имеющая нименьший приоритет имеет номер 0.

## Каталоги внутри каталога *queues/X/*

### Файлы внутри каталога *qos*

- *tagmap* - задание набора тегов (pcp и tos), кадры с которыми будут помещаться в данную очередь.
**Тип данных:** карта байтов.
Определяет какие теги (pcp или tos) помещают кадр в данную очередь.

- *weight* - задание числа кадров, после передачи которых будет происходить переход к следующей очереди.
**Тип данных:** число.
**Возможные значения при чтении:** десятеричное число в диапозоне [0-15], обозначающее количество пакетов. Если в очереди с номером 3 значение 0, то эта очередь переходит в режим строгого приоритета.
**Возможные значения при записи:** десятеричное число в диапозоне [0-15], обозначающее количество пакетов. Если в очередь с номером 3 записать значение 0, то эта очередь перейдет в режим строгого приоритета. **Рекомендуется не менять значения без доступа к документации коммутатора**

- *flow_control_threshold* - установка значения порога, при котором кадры для каждой очереди начнут отбрасываться.
**Тип данных:** число.
**Возможные значения при чтении:** десятеричное число в диапозоне [0-255], обозначающее пороговое количество кадров.
**Возможные значения при записи:** десятеричное число в диапозоне [0-255], обозначающее пороговое количество кадров. 
**Рекомендуется не менять значения без доступа к документации коммутатора**

- *portmap* - Задание портов, относящихся к очереди.
**Тип данных:** карта байтов.
Определяет, какие порты принадлежат какой очереди по-умолчанию.

- *priority_tag* - задание наиболее приоритетного тега в очереди.
**Тип данных:** число.
**Возможные значения при чтении:** десятеричное число [0-8], обозначающее тег, который является проритетным для очереди.
**Возможные значения при записи:** десятеричное число [0-8], обозначающее тег, который должен быть приоритетным для очереди.

## Каталоги внутри каталога *ports*

Внутри каталога ports присутствуют подкаталоги с номерами портов. Номера портов соответствуют их физическим номерам.

## Файлы внутри каталога *ports/X/*

### Файлы внутри каталога *qos*

- *enable_flow_control_on_threshold* - отбрасывание кадров порта при переполненной глобальной очереди.
**Тип данных:** булевый.
**Возможные значения при чтении:** 1 (отбрасывание отключено) и 0 (отбрасывание будет производится исходя из состояния глобальной очереди).  
**Возможные значения при записи:** 1 (отключить отбрасывание) и 0 (производить отбрасывание пакетов исходя из состояния глобальной очереди).

- *auto_turn_off_flow_control* - автоматическое отключение Flow Control при поступлении кадра с самым высоким приоритетом.
**Тип данных:** булевый.
**Возможные значения при чтении:** 1 (авто-отключение включено) и 0 (авто-отключение выключено).
**Возможные значения при записи:** 1 (включить авто-отключение) и 0 (выключить авто-отключение).

- *use_tos_to_select_queue* - использование поля TOS в пакете для выбора очереди.
**Тип данных:** булевый.
**Возможные значения при чтении:** 1 (использовать значение поля TOS для выбора очереди) и 0 (не использовать значение поля TOS для выбора очереди).
**Возможные значения при записи:** 1 (использовать значение поля TOS для выбора очереди) и 0 (не использовать значение поля TOS для выбора очереди).

- *use_pcp_to_select_queue* - использование поля PCP во VLAN-метке кадра для выбора очереди.
**Тип данных:** булевый.
**Возможные значения при чтении:** 1 (использовать значение поля pcp VLAN метки для выбора очереди) и 0 (не использовать значение поля pcp VLAN метки для выбора очереди).
**Возможные значения при записи:** 1 (использовать значение поля pcp VLAN метки для выбора очереди) и 0 (не использовать значение поля pcp VLAN метки для выбора очереди).

- *default_queue* - привязка порта к очереди по-умолчанию (для случаев, когда выключены использование tos и pcp. В противном случае для выбора актуальной очереди будут использоваться настройки из qos/queues/X/tagmap и значения полей tos или pcp, в зависимости от состояния 'use_tos_to_select_queue' и 'use_pcp_to_select_queue', а также 'preference_to_select_queue').
**Тип данных:** число.
**Возможные значения при чтении:** число, обозначающее номер очереди, к которой привязан порт.
**Возможные значения при записи:** число, обозначающее номер очереди, к которой привязан порт.

### Файлы внутри каталога *security*

- *addresses* - задание допустимых mac-адресов с которыми будет работать порт (при случае пустого файла, secured mode будет отключен для текущего порта).
**Тип данных:** список данных формата *HH:HH:HH:HH:HH:HH*
**Возможные значения при чтении:** список mac-адресов, с которыми порт будет взаимодействовать.
**Возможные значения при записи:** список mac-адресов, с которыми порт будет взаимодействовать, удовлетворяющих виду *HH:HH:HH:HH:HH:HH*.

### Файлы внутри каталога *led*

- *state* - настройка режима работы светодиода порта.
**Тип данных:** строка
**Возможные значения при чтении:** off - выключить светодиод порта, on - включить постоянное горение светодиода, linkact - включить режим при котором светодиод горит при наличии активного соединения и мерцает при прохождении кадров, ? - при другом включенном режиме (введите какое-то из предложенных значений).
**Возможные значения при записи:** off - выключить светодиод порта, on - включить постоянное горение светодиода, linkact - включить режим при котором светодиод горит при наличии активного соединения и мерцает при прохождении кадров.

### Файлы внутри каталога *mgmt*

- *doubletagging* - настройка режима работы с тегированными кадрами.
**Тип данных:** строка
**Возможные значения при чтении:** yes - разрешен прием тегириванных кадров на внешнем порту, no - на внешнем порту принимаются только нетегированные кадры.
**Возможные значения при записи:** yes - разрешить прием тегириванных кадров на внешнем порту, no - принимать на внешнем порту только нетегированные кадры.

## Файлы и каталоги каталога *mgmt*

- *bcast_storm_protection* - файл, управляющий уровенем защиты от широковещательного шторма.
**Тип данных:** строка.
**Возможные значения при чтении:** none - отключено, strong - защита активируется при наличии 64 широковещательных кадров в выходной очереди, medium - 96 кадров, soft - 128 кадров.
**Возможные значения при записи:** none - отключено, strong - включать защиту при наличии 64 широковещательных кадров в выходной очереди, medium - 96 кадров, soft - 128 кадров.

- *offloading* - файл, управляющий режимом аппаратной коммутации. Включает или выключает режим аппаратной коммутации. Аналогичен параметру bridge_offloading в DTS.
**Тип данных:** строка.
**Возможные значения при чтении:** no - аппаратная коммутация отключена, yes - аппаратная коммутация включена.
**Возможные значения при записи:** no - аппаратная коммутация отключена, yes - аппаратная коммутация включена.

## Файлы каталога *mgmt/thresholds*

- *flow_control* - файл для установки порога, при котором функция Flow Control будет задействовна или отключена.
**Возможные значения при чтении:** десятеричное число в диапозоне [0-255], обозначающее количество кадров глобальной очереди, при превышении которого FC будет отключена.
**Возможные значения при записи:** десятеричное число в диапозоне [0-255], обозначающее количество кадров глобальной очереди, при превышении которого FC будет отключена. **Рекомендуется не менять значения без доступа к документации коммутатора**

- *drop* - файл для установки порога, при котором отброс пакетов будет отключен.
**Возможные значения при чтении:** десятеричное число в диапозоне [0-255], обозначающее количество кадров глобальной очереди, при превышении которого кадры начнут отбрасываться.
**Возможные значения при записи:** десятеричное число в диапозоне [0-255], обозначающее количество кадров глобальной очереди, при превышении которого кадры начнут отбрасываться. **Рекомендуется не менять значения без доступа к документации коммутатора**
