
define KernelPackage/rt3050-esw
  SUBMENU:=Network Devices
  TITLE:=Original switch driver for RT3050/MT76x8 SoCs
  DEPENDS:=@(TARGET_ramips_mt76x8||TARGET_ramips_rt3050) +kmod-swconfig
  KCONFIG:= \
	CONFIG_NET_RALINK_ESW_RT3050=m \

  FILES:=$(LINUX_DIR)/drivers/net/ethernet/ralink/esw_rt3050.ko
  AUTOLOAD:=$(call AutoLoad,10,esw_rt3050)
endef

define KernelPackage/rt3050-esw/description
This package provides loadable kernel module for rt3050 switch which can be found in RT3050 and MT76x8 SoCs.
The module implements original driver.
endef

$(eval $(call KernelPackage,rt3050-esw))

define KernelPackage/rt3050-eth
  SUBMENU:=Network Devices
  TITLE:=Ethernet driver for RT3050/MT76x8 SoCs
  DEPENDS:=@(TARGET_ramips_mt76x8||TARGET_ramips_rt3050) +kmod-rt3050-esw
  KCONFIG:= \
	CONFIG_NET_VENDOR_RALINK=m \
	CONFIG_NET_RALINK_RT3050=y \
	CONFIG_NET_RALINK_MT7620=n \

  FILES:=$(LINUX_DIR)/drivers/net/ethernet/ralink/ralink-eth.ko
  AUTOLOAD:=$(call AutoLoad,11,ralink-eth)
endef
$(eval $(call KernelPackage,rt3050-eth))

define KernelPackage/rt3050-eth/description
This package provides loadable kernel module for rt3050/mt76x8 SoCs ethernet.
endef

define KernelPackage/mt76x8-eth
  SUBMENU:=Network Devices
  TITLE:=Ethernet driver for RT5350/MT76x8 SoCs
  DEPENDS:=@(TARGET_ramips_mt76x8||TARGET_ramips_rt3050)
  KCONFIG:= \
	CONFIG_NET_VENDOR_MEDIATEK=y \
	CONFIG_NET_MEDIATEK_SOC=m \

  FILES:=$(LINUX_DIR)/drivers/net/pcs/pcs-mtk-lynxi.ko \
	$(LINUX_DIR)/drivers/net/ethernet/mediatek/mtk_eth.ko
  AUTOLOAD:=$(call AutoLoad,10,pcs-mtk-lynxi mtk_eth)
endef

define KernelPackage/rt3050-eth/description
This package provides loadable kernel module for rt3050/mt76x8 SoCs ethernet.
endef
$(eval $(call KernelPackage,mt76x8-eth))

define KernelPackage/rt3050-dsa-switch
  SUBMENU:=Network Devices
  TITLE:=DSA-style switch driver for RT3050/MT76x8 SoCs
  DEPENDS:=@(TARGET_ramips_mt76x8||TARGET_ramips_rt3050) +kmod-mt76x8-eth
  KCONFIG:= \
	CONFIG_NET_DSA=y \
	CONFIG_NET_DSA_RT3050=m \
	CONFIG_NET_DSA_RT3050_DEBUGFS=n \
	CONFIG_NET_DSA_TAG_RT3050_8021Q=y \

  FILES:=$(LINUX_DIR)/drivers/net/dsa/rt3050/rt3050-switch.ko
  AUTOLOAD:=$(call AutoLoad,11,rt3050-switch)
endef

define KernelPackage/rt3050-dsa-switch/description
This package provides loadable kernel module for rt3050 switch which can be found in RT3050 and MT76x8 SoCs.
The module implements DSA-style driver.
endef

define KernelPackage/rt3050-dsa-switch-debug
  SUBMENU:=Network Devices
  TITLE:=DSA-style switch driver for RT3050/MT76x8 SoCs with debugfs interface
  DEPENDS:=@(TARGET_ramips_mt76x8||TARGET_ramips_rt3050) +kmod-mt76x8-eth
  KCONFIG:= \
	CONFIG_NET_DSA=y \
	CONFIG_NET_DSA_RT3050=m \
	CONFIG_NET_DSA_RT3050_DEBUGFS=y \
	CONFIG_NET_DSA_TAG_RT3050_8021Q=y \

  FILES:=$(LINUX_DIR)/drivers/net/dsa/rt3050/rt3050-switch.ko
  AUTOLOAD:=$(call AutoLoad,11,rt3050-switch)
endef

define KernelPackage/rt3050-dsa-switch-debug/description
This package provides loadable kernel module for rt3050 switch which can be found in RT3050 and MT76x8 SoCs.
The module implements DSA-style driver and debugfs interface to see extensive information about
the internal state of rt3050-dsa-switch in debugfs.
endef

$(eval $(call KernelPackage,rt3050-dsa-switch))
$(eval $(call KernelPackage,rt3050-dsa-switch-debug))
