#ifndef __TAG_RT3050_8021Q_H
#define __TAG_RT3050_8021Q_H
#include <linux/dsa/8021q.h>
#include <net/dsa.h>

#define RT3050_PORT0		0
#define RT3050_PORT1		1
#define RT3050_PORT2		2
#define RT3050_PORT3		3
#define RT3050_PORT4		4
#define RT3050_PORT5		5
#define RT3050_PORT6		6

static inline u16 dsa_8021q_rt3050_port_to_vid(int port)
{
	return (u16)(port + 1);
}

static inline u16 dsa_8021q_vid_to_rt3050_vlan(u16 vid)
{
	return vid & GENMASK(3,0);
}

static inline int dsa_8021q_vid_to_rt3050_port(u16 vid)
{
	return (int)(dsa_8021q_vid_to_rt3050_vlan(vid)) - 1;
}

static inline u16 rt3050_port_to_dsa_8021q_vid(int port)
{
	if ((port >= 0) && (port < RT3050_PORT5))
		return (u16)(port + 1);
	return 0;
}

static inline int dsa_8021q_port_to_rt3050_port(int port)
{
	return port - 1;
}

static inline int dsa_8021q_port_to_rt3050_port_vid(int port)
{
	return port + 1;
}

static inline u16 dsa_8021q_rt3050_tx_vid(struct dsa_port *dp)
{
	return dsa_8021q_vid_to_rt3050_vlan(dsa_8021q_tx_vid(dp->ds, dsa_8021q_port_to_rt3050_port_vid(dp->index)));
}

#endif
