#ifndef _RT3050_PROCFS_H
#define _RT3050_PROCFS_H

struct rt3050_priv;

#if IS_ENABLED(CONFIG_PROC_FS)
#include <linux/fs.h>
#include <linux/proc_fs.h>

int rt3050_switch_create_procfs(struct rt3050_priv *priv);
void rt3050_switch_remove_procfs(struct rt3050_priv *priv);
#else
static inline int rt3050_switch_create_procfs(struct rt3050_priv *priv)
{
	return 0;
}

static inline void rt3050_switch_remove_procfs(struct rt3050_priv *priv)
{
	return;
}
#endif /* IS_ENABLED(CONFIG_PROC_FS) */
#endif /* _RT3050_PROCFS_H */
