# Общая архитектура решения

Решение состоит из двух отдельных драйверов и патча для ядра Линукс, а также набора файлов документации и примеров (в том числе собираемого пакета).

## Драйвера

В состав решения входят отдельно оформленные драйвера:
1. непосредственно коммутатора, реализующего DSA-режим;
2. протокола тегирования, построенного на базе протокола тегирования 8021Q для DSA-коммутаторов.

В общем дереве исходных кодов 1-ый драйвер располагается по относительному (к корню исходных текстов ядра Линукс) пути drivers/net/dsa/rt3050, а в архиве rt305-dsa-switch/target/linux/ramips/files-5.15/drivers/net/dsa/rt3050. 2-ой драйвер располагается по относительным путям include/linux/dsa/ и net/dsa/, а в архиве rt305-dsa-switch/target/linux/ramips/files-5.15/include/linux/dsa/ и rt305-dsa-switch/target/linux/ramips/files-5.15/net/dsa/.

**Перед использованием содержимое папки архива rt305-dsa-switch/target/linux/ramips/files-5.15 следует скопировать в каталог target/linux/ramips/files-5.15, а при отсутствии данной папки в target/linux/ramips/files сборочной системы**

**Внимание! DSA-драйвер является несовместимым со стандартным для платформы MT76x8 драйверами коммутатора (esw_rt3050 / "rt3050-esw") и ethernet (NET_VENDOR_RALINK / "ralink,rt5350-eth"). Отключение использования этих драйверов должно быть выполнено через удаление соответствующих узлов в DTS-файле и (или) отключение параметра конфигурации ядра NET_VENDOR_RALINK.**

**Внимание! DSA-драйвер для своей работы требует использования ethernet драйвера, активируемого параметром конфигурации ядра NET_VENDOR_MEDIATEK.**

**См. пример DTS-файла**

## Патч ядра

В состав решения входит патч для ядра Линукс, изменяющий параметры настройки ядра Линукс, включающий в процесс сборки новые драйвера.
**Перед использованием содержимое папки архива rt305-dsa-switch/target/linux/ramips/patches-5.15 следует скопировать в каталог target/linux/ramips/patches-5.15, а при отсутствии данной папки в target/linux/ramips/pathes сборочной системы**

## Файл с целями для сборки пакетов с драйверами.

В состав решения входит файл, позволяющий собрать необходимый набор драйверов для целевой системы. В архиве файл располагается по адресу rt3050-dsa-switch/package/kernel/linux/modules/.
Файлом предоставляются 3 цели сборки:
1. Классический драйвер коммутатора и ethernet.
2. DSA-драйвер и ethernet-драйвер с включенной опцией отладочной файловой системы.
3. DSA-драйвер и ethernet-драйвер без опции отладочной файловой системы.

**Внимание! Для сборки может быть указана только одна цель из трех.**

**Перед использованием содержимое папки архива rt305-dsa-switch/package следует скопировать в каталог package сборочной системы**

## Файлы с примерами и документацией

Располагаются в папке target/linux/ramips/Documentation

## Прочее

Папка diff архива содержит оригинальные (подкаталог a) и модифицированные (подкаталог b) файлы, по которым сформирован указанный выше патч.
