# Потребные изменения DTS-файлов

Для использования DSA-коммутатора потребуется внести изменения в файл mt7628an.dtsi и файл конкретного устройства.

## Изменение файла mt7628an.dtsi

*Для использования нового драйвера коммутатора, в файл mt7628an.dtsi потребуется добавить следующие описания устройств:*

	ethernet: ethernet@10100000 {
		compatible = "ralink,rt5350-eth";
		reg = <0x10100000 0x10000>;

		interrupt-parent = <&cpuintc>;
		interrupts = <5>;

		resets = <&sysc 21>;
		reset-names = "fe";

		gmac0: mac@0 {
			compatible = "mediatek,eth-mac";
			reg = <0>;
			phy-mode = "rgmii";

			fixed-link {
				speed = <1000>;
				full-duplex;
				pause;
			};
		};

	};


	switch0: switch0@10110000 {
		compatible = "mediatek,rt3050-dsa-switch";
		reg = <0x10110000 0x8000>;

		resets = <&sysc 23>, <&sysc 24>;
		reset-names = "esw", "ephy";

		interrupt-parent = <&intc>;
		#interrupt-cells = <1>;
		interrupts = <17>;

		/* bridge_offloading; */ /* Uncomment to enable port to port switch offloaded bridge */
		/* engineering_mode; */ /* Uncomment to have switch in simple mode */
		/* portmap = <10>; */ /* Field to specify port layout. E.g. to select Wan port by 1 in such bit. <1> - Left port is Wan. <10> - Right port is Wan */
		/* led_source = <u32 bit map>; */ /* LED source bitmap in u32 form. Please, refer to MT7628 Datasheet/Programming Guide for more information */
		/* led_polarity = <0>; */ /* LED source bitmap in u32 form. 0 means 'Low active' in port bit. 1 means 'High active' */

		ports {
			#address-cells = <1>;
			#size-cells = <0>;

			port@0 {
				status = "disabled";
				reg = <0>;
				label = "lan0";
			};

			port@1 {
				status = "disabled";
				reg = <1>;
				label = "lan1";
			};

			port@2 {
				status = "disabled";
				reg = <2>;
				label = "lan2";
			};

			port@3 {
				status = "disabled";
				reg = <3>;
				label = "lan3";
			};

			port@4 {
				status = "disabled";
				reg = <4>;
				label = "lan4";
			};

			port@6 {
				reg = <6>;
				ethernet = <&gmac0>;
				phy-mode = "rgmii";

				fixed-link {
					speed = <1000>;
					full-duplex;
					pause;
				};
			};
		};
	};

## Пример изменения в файле конкретного устройства

*Определяем для eth0 MAC-адрес и где он лежит:*

&gmac0 {

	nvmem-cells = <&macaddr_factory_28>;

	nvmem-cell-names = "mac-address";

};


*Включаем коммутатор с двумя активными портами; называем их eth1 и eth2; включаем режим аппаратного ускорения для сетевых мостов.*

&switch0 {

	bridge_offloading;

	ports {
		port@0 {
			status = "okay";
			label = "eth1";
		};

		port@1 {
			status = "okay";
			label = "eth2";
		};
	};
};


## Замечания по возможному расхождению названий некоторых узлов в DTS-файлах

При использовании различных версий ядра Линукс и (или) разных версий (вариантов) DTS-файлов для платформы MT7628AN в процессе сборки могут появиться ошибки, связанные с отсутствием (чаще всего, с другими именами определенных узлов в описании платформы.

Например, может отсутствовать узел <&sysc>, на который мы ссылаемся в своей DTS.

В данном случае, проблема решается поиском соответствующего по функциям узла в локальных DTS-файлах и замена отсутствующего названия на имеющееся.

**Например. Узел &sysc отсуствует. Речь идет о контроллере / механизме сбросов (reset). В локальном DTS-файле присутствует узел контроллер сбросов с именем &rstctrl. Заменяем в итоговом DTS-файле ссылки на &sysc ссылками на &rstctrl.**
