#include <plib/utils.h>

/* Check */

static BOOL sched_list(const char * user) {
    BOOL	res = FALSE;
    val_t	* root = sched_list_jobs(user);

    if (root != NULL) {
	blob_t * blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0);

	if ((blob != NULL) && (blob->end > 0)) {
	    res = TRUE;
	    sock_write(1, blob_base(blob), blob->end, 10);
	    printf("\n");
	    blob_free(blob);
	}
	val_free(root);
    }
    return res;
}

static void usage(const char * arg, int code) {
    fprintf(stderr, "Usage: %s list|restore|remove|install|check [OPTIONS] \n", arg);
    exit(code);
}

static void usage_list(const char * arg, int code) {
    fprintf(stderr, "Usage: %s list USERNAME \n", arg);
    exit(code);
}

static void usage_remove(const char * arg, int code) {
    fprintf(stderr, "Usage: %s remove all|USERNAME \n", arg);
    exit(code);
}

static void usage_check(const char * arg, int code) {
    fprintf(stderr, "Usage: %s check USERNAME RULE\n", arg);
    exit(code);
}

static void usage_delete(const char * arg, int code) {
    fprintf(stderr, "Usage: %s delete USERNAME RULE\n", arg);
    exit(code);
}

static void usage_install(const char * arg, int code) {
    fprintf(stderr, "Usage: %s install USERNAME RULE\n", arg);
    exit(code);
}

int main(int argc, char * argv[]) {
    BOOL	res = FALSE;

    if (strstr(argv[0], "list") != NULL) {
	if (argc != 2)
	    usage_list(argv[0], 1);
	res = sched_list(argv[1]);
    } else if (strstr(argv[0], "restore") != NULL) {
	sched_restore_jobs();
    } else if (strstr(argv[0], "remove") != NULL) {
	if (argc != 2)
	    usage_remove(argv[0], 1);
	if (strcmp(argv[1], "all") == 0) {
	    sched_remove_all_jobs();
	    res = TRUE;
	} else
	    res = sched_remove_jobs(argv[1]);
    } else if (strstr(argv[0], "check") != NULL) {
	if (argc != 3)
	    usage_check(argv[0], 1);
	res = sched_is_job_installed_uniq(argv[1], argv[2]);
    } else if (strstr(argv[0], "delete") != NULL) {
	if (argc != 3)
	    usage_delete(argv[0], 1);
	res = sched_remove_job_uniq(argv[1], argv[2]);
    } else if (strstr(argv[0], "install") != NULL) {
	if (argc != 3)
	    usage_install(argv[0], 1);
	res = sched_install_job(argv[1], argv[2]);
    } else {
	if (argc < 3)
	    usage(argv[0], 1);
	if (strcmp(argv[1], "list") == 0) {
	    if (argc != 3)
		usage_list(argv[0], 1);
	    res = sched_list(argv[2]);
	} else if (strcmp(argv[1], "restore") == 0) {
	    sched_restore_jobs();
	} else if (strcmp(argv[1], "remove") == 0) {
	    if (argc != 3)
		usage_remove(argv[0], 1);
	    if (strcmp(argv[2], "all") == 0) {
		sched_remove_all_jobs();
		res = TRUE;
	    } else
		res = sched_remove_jobs(argv[2]);
	} else if (strcmp(argv[1], "check") == 0) {
	    if (argc != 4)
		usage_check(argv[0], 1);
	    res = sched_is_job_installed_uniq(argv[2], argv[3]);
	} else if (strcmp(argv[1], "delete") == 0) {
	    if (argc != 4)
		usage_delete(argv[0], 1);
	    res = sched_remove_job_uniq(argv[2], argv[3]);
	} else if (strcmp(argv[1], "install") == 0) {
	    if (argc != 4)
		usage_install(argv[0], 1);
	    res = sched_install_job(argv[2], argv[3]);
	} else {
	    usage(argv[0], 1);
	}
    }
    if (res)
	return 0;
    return -1;
}