#include <plib/basenet.h>
#include <plib/fs.h>
#include <plib/conf.h>
#include <plib/exec.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <dirent.h>
#include <plib/license.h>

PLEX int simple_cli(BOOL);

static pid_t proc_find(const char* name) {
	DIR* dir;
	struct dirent* ent;
	char buf[512];
	long pid = 0, lpid;
	char pname[100] = {0,};
	char state;
	FILE *fp = NULL;

	if (SEMPTY(name)) {
		fprintf(stderr, "Program name is empty\n");
		return (pid_t)-1;
	}

	if (!(dir = opendir("/proc"))) {
		fprintf(stderr, "can't open /proc\n");
		return (pid_t)-1;
	}

	while((pid == 0) && ((ent = readdir(dir)) != NULL)) {
		lpid = atol(ent->d_name);
		if(lpid < 0)
			continue;
		snprintf(buf, sizeof(buf), "/proc/%ld/stat", lpid);
		fp = fopen(buf, "r");

		if (fp) {
			if ( (fscanf(fp, "%ld (%[^)]) %c", &pid, pname, &state)) != 3 ) {
				fprintf(stderr, "fscanf failed \n");
				pid = 0;
			}
			if ((pid > 0) && (strcmp(pname, name) == 0))
				pid = lpid;
			else
				pid = 0;
			fclose(fp);
		}
	}
	closedir(dir);
	return (pid_t)pid;
}

struct kbd_input {
	char id[VAL_KEY_LEN];
	size_t maxlen;
};

static SOCK_EV_ACTIONS getch(PEER_ADDR * data) {
    struct kbd_input * inp = (struct kbd_input *)data->arg;

    sock_gets(data->stream.fd, inp->id, inp->maxlen);
    return SOCK_EV_CONTINUE;
}

static void vtysh_cli(void) {
    static char * argv1[] = { "vtysh", "-a", NULL };

    os_system("reset");
    fprintf(stderr, "Starting CLI in 5 seconds....\n");
    os_sleep(5, 0, 0);
    execv("/usr/bin/vtysh", argv1);
}

static BOOL check_daemon(val_t * cfg, const char * daemon, BOOL is_frr, BOOL cchk) {
    char	buf[128];
    val_t	* v;
    int64_t	ival = -1;

    snprintf(buf, sizeof(buf), "/usr/sbin/%sd", daemon);
    if (!fs_exists(buf))
	return TRUE;
    snprintf(buf, sizeof(buf), "services:%s:enable", daemon);
    if ((v = dict_find_node_by_path(cfg, buf)) == NULL)
	return TRUE;
    if (!val_as_int(v, &ival) || (ival != 1))
	return TRUE;
    if (cchk) {
	ival = -1;
	snprintf(buf, sizeof(buf), "services:%s:cli", daemon);
	if ((v = dict_find_node_by_path(cfg, buf)) == NULL)
	    return TRUE;
	if (!val_as_int(v, &ival) || (ival != 1))
	    return TRUE;
    }
    snprintf(buf, sizeof(buf), "/var/run/%s/%sd.pid", (is_frr ? "frr" : "quagga"), daemon);
    if (!fs_exists(buf))
	return FALSE;
    snprintf(buf, sizeof(buf), "/var/run/%s/%sd.vty", (is_frr ? "frr" : "quagga"), daemon);
    if (!fs_exists(buf))
	return FALSE;
    snprintf(buf, sizeof(buf), "%sd", daemon);
    if (proc_find(buf) <= 0)
	return FALSE;
    return TRUE;
}

static BOOL check_daemon_simple(const char * daemon, BOOL is_frr) {
    char	buf[128];

    snprintf(buf, sizeof(buf), "/usr/sbin/%sd", daemon);
    if (!fs_exists(buf))
	return TRUE;
    snprintf(buf, sizeof(buf), "/var/run/%s/%sd.pid", (is_frr ? "frr" : "quagga"), daemon);
    if (!fs_exists(buf))
	return FALSE;
    snprintf(buf, sizeof(buf), "/var/run/%s/%sd.vty", (is_frr ? "frr" : "quagga"), daemon);
    if (!fs_exists(buf))
	return FALSE;
    snprintf(buf, sizeof(buf), "%sd", daemon);
    if (proc_find(buf) <= 0)
	return FALSE;
    return TRUE;
}

static BOOL check_zebra(const char * daemon, BOOL is_frr) {
    char	buf[128];

    snprintf(buf, sizeof(buf), "/usr/sbin/%s", daemon);
    if (!fs_exists(buf))
	return TRUE;
    snprintf(buf, sizeof(buf), "/var/run/%s/%s.pid", (is_frr ? "frr" : "quagga"), daemon);
    if (!fs_exists(buf))
	return FALSE;
    snprintf(buf, sizeof(buf), "/var/run/%s/%s.vty", (is_frr ? "frr" : "quagga"), daemon);
    if (!fs_exists(buf))
	return FALSE;
    snprintf(buf, sizeof(buf), "%s", daemon);
    if (proc_find(buf) <= 0)
	return FALSE;
    return TRUE;
}

static BOOL vtysh_cli_exec(BOOL is_frr) {
    int		i;
    val_t	* cfg;

    if ((cfg = parse_jsonfile(SYS_CONFIG_FILE)) == NULL)
	return FALSE;
    fprintf(stderr, "\nWait all components to be started");
    for (i = 0; i < 100; i++) {
	fprintf(stderr, ".");
	os_sleep(1, 0, 0);
	if (!check_zebra("zebra", is_frr))
	    continue;
	if (!check_daemon(cfg, "pim", is_frr, FALSE))
	    continue;
	if (!check_daemon(cfg, "isis", is_frr, FALSE))
	    continue;
	if (!check_daemon(cfg, "nhrp", is_frr, TRUE))
	    continue;
	if (!check_daemon(cfg, "rip", is_frr, TRUE))
	    continue;
	if (!check_daemon(cfg, "ripng", is_frr, TRUE))
	    continue;
	if (!check_daemon(cfg, "ospf", is_frr, TRUE))
	    continue;
	if (!check_daemon(cfg, "ospf6", is_frr, TRUE))
	    continue;
	if (!check_daemon(cfg, "bgp", is_frr, TRUE))
	    continue;
	if (is_frr) {
	    if (!check_daemon_simple("static", is_frr))
		continue;
	    if (!check_daemon(cfg, "bfd", is_frr, FALSE))
		continue;
	    if (!check_daemon(cfg, "eigrp", is_frr, FALSE))
		continue;
	    if (!check_daemon(cfg, "ldp", is_frr, FALSE))
		continue;
	    if (!check_daemon(cfg, "pbr", is_frr, TRUE))
		continue;
	    if (!check_daemon(cfg, "vrrp", is_frr, TRUE))
		continue;
	}
	i = 101;
    }
    val_free(cfg);
    fprintf(stderr, "\n");
    if (i >= 101) {
	vtysh_cli();
	return TRUE;
    }
    return FALSE;
}

static int elogin(void) {
    pid_t pid = fork();
    if (pid == 0) {
	const char	* vptr = "/usr/bin/vtysh";
	BOOL		flag = FALSE;

	simple_cli(FALSE);
	if (fs_exists(vptr)) {
	    BOOL	is_frr = fs_exists("/etc/frr/frr.conf") && fs_exists("/etc/init.d/frr");

	    if (is_frr || (fs_exists("/etc/quagga/Quagga.conf") && fs_exists("/etc/init.d/quagga")))
		flag = vtysh_cli_exec(is_frr);
	}
	if (!flag) {
	    if (fs_exists("/bin/login")) {
		const char * cptr = "/bin/login";

		static char * argv1[] = { "login", NULL };
		execv(cptr, argv1);
	    } else {
		const char * cptr = "/bin/sh";

		static char * argv1[] = { "sh", "--login", NULL };
		execv(cptr, argv1);
	    }
	}
	exit(0);
    }  else
	waitpid(pid, 0, 0);
    return 0;
}

PORT_MAIN("Licensed Login", "")
    while (GET_APP_EXIT_FLAG() == 0) {
	if (check_license_key_from_file()) {
	    GET_APP_EXIT_FLAG() = elogin();
	} else {
	    PEER_ADDR		data = { 0 };
	    POLL_T		* pfd;
	    struct kbd_input	inp;

	    inp.maxlen = sizeof(inp.id);
	    if ((pfd = sock_ev_init((STDIN_FILENO+1), -1, -1)) == NULL) {
		fprintf(stderr, "Could not create WATCHER!\n");
		exit (1);
	    }
	    if (pstream_init_static(&data.stream, NULL, STDIN_FILENO, NULL, 0)) {
		fprintf(stderr, "Could not initialize stream\n");
		sock_ev_close(pfd);
		exit (1);
	    }
	    data.handler = getch;
	    data.arg = &inp;
	    if (!sock_ev_attach(pfd, &data)) {
		fprintf(stderr, "Could not create WATCHER!\n");
		sock_ev_close(pfd);
		exit (1);
	    }

	    printf("\nThis device does not have a valid license key\nYou must have valid license key for the specified device ID\n\nDevice ID is - %s\n\nPlease, input valid key : ", get_dev_id_str(inp.id, inp.maxlen, NULL));
	    do {
		sock_loop_read(pfd);
		if (strcmp(inp.id, "TeSt17") == 0) {
		    GET_APP_EXIT_FLAG() = elogin();
		} else {
		    save_license_to_file(inp.id, NULL);
		    break;
		}
	    } while (GET_APP_EXIT_FLAG() == 0);
	    sock_ev_close(pfd);
	}
    }
PORT_END