#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <plib/fs.h>
#include <plib/exec.h>
#include <dirent.h>

static void clean_config_line(const char * filename, const char * alterfilename, const char * line) {
	char buf[1024], newfilename[256];
	FILE * fp = NULL, * newfp;
	BOOL alterused = FALSE, modified = FALSE;

	if (!SEMPTY(filename))
		fp = fopen(filename, "r");
	if (fp == NULL) {
		if (!SEMPTY(alterfilename)) {
			fp = fopen(alterfilename, "r");
			alterused = TRUE;
		}
	    
	}
	if (fp == NULL)
		return;
	fs_tmp_name(NULL, newfilename, sizeof(newfilename));
	if ((newfp = fopen(newfilename, "w")) != NULL) {

		while (!feof(fp)) {
			if (fgets(buf, sizeof(buf), fp) != NULL) {
				if (strncmp(buf, line, strlen(line)) == 0)
					continue;
				fputs(buf, newfp);
				modified = TRUE;
			}
		}
		fclose(newfp);
	}
	fflush(fp);
	fclose(fp);
	if (modified) {
		fs_copyfile(newfilename, alterused ? alterfilename : filename);
		fs_remove(newfilename);
	}
}

static BOOL clean_config_section(const char * filename, const char * alterfilename, const char * msection, const char * subsection, int level) {
	char newfilename[256], section[512], newline1[128], newline2[128], newline3[128];
	FILE * fp = NULL, * newfp;
	BOOL alterused = FALSE, issue_line_cmd = FALSE, issue_section_cmd = FALSE, modified = FALSE;

	if (level > 10)
		return FALSE;
	if (!SEMPTY(filename))
		fp = fopen(filename, "r");
	if (fp == NULL) {
		if (!SEMPTY(alterfilename)) {
			fp = fopen(alterfilename, "r");
			alterused = TRUE;
		}
	    
	}
	if (fp == NULL)
		return FALSE;
	if (msection[0] == ' ')
		strncpy(section, msection, sizeof(section));
	else
		str_unescape(section, sizeof(section), msection);
	fs_tmp_name(NULL, newfilename, sizeof(newfilename));
	if ((newfp = fopen(newfilename, "w")) != NULL) {
		BOOL matched = FALSE;
		char ending[16], buf[1024], * p = ending;
		size_t len;

		while (level > 0) {
			*p ++ = ' ';
			level --;
		}
		*p ++ = 'e';
		*p ++ = 'x';
		*p ++ = 'i';
		*p ++ = 't';
		*p = 0;
		len = strlen(ending);
		while (!feof(fp)) {
			if (fgets(buf, sizeof(buf), fp) != NULL) {
				if (matched) {
					if (strncmp(buf, ending, len) == 0)
						matched = FALSE;
					continue;
				} else {
					if ((buf[0] != '!') && (strncmp(buf, section, strlen(section)) == 0)) {
						const char * ptr = buf + strlen(section);

						if ((*ptr == 0) || (isspace(*ptr))) {
							if (SEMPTY(subsection)) {
								matched = TRUE;
								continue;
							} else if (strstr(buf, subsection) != NULL) {
								matched = TRUE;
								if (strcmp(section, "interface") == 0) {
									issue_line_cmd = TRUE;
									snprintf(newline1, sizeof(newline1), " %s %s", section, subsection);
									snprintf(newline2, sizeof(newline2), " member bridge %s", subsection);
									snprintf(newline3, sizeof(newline3), " member bond %s", subsection);
								} else if ((strcmp(subsection, "firewall") == 0) && (level == 0)) {
									issue_section_cmd = TRUE;
									snprintf(newline1, sizeof(newline1), " %s", section);
								}
								continue;
							}
						}
					}
				}
				fputs(buf, newfp);
				modified = TRUE;
			}
		}
		fclose(newfp);
	}
	fflush(fp);
	fclose(fp);
	if (modified) {
		fs_copyfile(newfilename, alterused ? alterfilename : filename);
		fs_remove(newfilename);
	}
	if (issue_line_cmd) {
		clean_config_line(filename, alterfilename, newline1);
		clean_config_line(filename, alterfilename, newline2);
		clean_config_line(filename, alterfilename, newline3);
	}
	if (issue_section_cmd) {
		clean_config_section(filename, alterfilename, newline1, subsection, 1);
	}
	return TRUE;
}

void clean_config_all(void) {
	clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "start");
	clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "set");
	clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "hostname");
	clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "time");
	clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "wlan");
	clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "ip route");
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "aaa", NULL, 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "dns", NULL, 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "dhcp", NULL, 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "zone", NULL, 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "ip", "firewall", 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "ipv6", "firewall", 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "interface", NULL, 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "router", "bgp", 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "router", "ospf", 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "router", "ospf6", 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "router", "rip", 0);
	clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", "router", "ripng", 0);
}

static pid_t proc_find(const char* name) {
	DIR* dir;
	struct dirent* ent;
	char buf[512];
	long pid = 0, lpid;
	char pname[100] = {0,};
	char state;
	FILE *fp = NULL;

	if (SEMPTY(name)) {
		fprintf(stderr, "Program name is empty\n");
		return (pid_t)-1;
	}

	if (!(dir = opendir("/proc"))) {
		fprintf(stderr, "can't open /proc\n");
		return (pid_t)-1;
	}

	while((pid == 0) && ((ent = readdir(dir)) != NULL)) {
		lpid = atol(ent->d_name);
		if(lpid < 0)
			continue;
		snprintf(buf, sizeof(buf), "/proc/%ld/stat", lpid);
		fp = fopen(buf, "r");

		if (fp) {
			if ( (fscanf(fp, "%ld (%[^)]) %c", &pid, pname, &state)) != 3 ) {
				fprintf(stderr, "fscanf failed \n");
				pid = 0;
			}
			if ((pid > 0) && (strcmp(pname, name) == 0))
				pid = lpid;
			else
				pid = 0;
			fclose(fp);
		}
	}
	closedir(dir);
	return (pid_t)pid;
}

static void usage(const char * progname) {
	fprintf(stderr, "Usage: %s <all|line|section> [LINE|SUBSECTION]\n", progname);
	exit(1);
}

int main(int argc, char* argv[]) {
	pid_t	pid;

	if (argc < 2)
		usage(argv[0]);

	while ((pid = proc_find("vtysh")) > 0) {
	    os_kill(pid, SIGKILL);
	}
	if (strcmp(argv[1], "all") == 0)
		clean_config_all();
	else if (strcmp(argv[1], "line") == 0) {
		char buf[512], * ptr = buf;
		int argi = 2, notfirst = 0;
		size_t remain = sizeof(buf);

		if (argc < 3)
			usage(argv[0]);
		while (argi < argc) {
			int len;

			if (notfirst) {
				len = snprintf(ptr, remain, " ");
				ptr += len;
				remain -= len;
			}
			len = snprintf(ptr, remain, "%s", argv[argi]);
			ptr += len;
			remain -= len;
			notfirst = 1;
			argi ++;
		}
		clean_config_line("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", buf);
	} else if (strcmp(argv[1], "section") == 0) {
		const char * ptr = NULL;
		int lvl = 0;

		if (argc < 3)
			usage(argv[0]);
		if (argc >= 4)
			ptr = argv[3];
		if (argc > 4)
			lvl = atoi(argv[4]);
		if (!clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", argv[2], ptr, lvl))
			clean_config_section("/etc/frr/frr.conf", "/etc/quagga/Quagga.conf", argv[2], ptr, lvl);
	}
	fs_remove("/var/run/vtysh_aaa.lock");
	return 0;
}

