#include <plib/smtp.h>

PLEX SMTP_STATUS_CODE smtp_status_code_get(const struct smtp * smtp) {
    return smtp->status_code;
}

PLEX SMTP_STATUS_CODE smtp_status_code_clear(struct smtp * smtp) {
    enum smtp_status_code old_status;

    old_status = smtp_status_code_get(smtp);
    smtp_status_code_set(smtp, SMTP_STATUS_OK);
    return old_status;
}

PLEX SMTP_STATUS_CODE smtp_status_code_set(struct smtp * smtp, SMTP_STATUS_CODE status_code) {
    if ((unsigned)status_code >= SMTP_STATUS_LAST)
	return smtp_status_code_set(smtp, SMTP_STATUS_PARAM);
    smtp->status_code = status_code;
    return status_code;
}

PLEX const char * smtp_status_code_errstr(SMTP_STATUS_CODE status_code){
    static const char *const status_code_err_str[] = {
    /* SMTP_STATUS_OK */
    "Success",
    /* SMTP_STATUS_NOMEM */
    "Memory allocation failed",
    /* SMTP_STATUS_CONNECT */
    "Failed to connect to the mail server",
    /* SMTP_STATUS_HANDSHAKE */
    "Failed to handshake or negotiate a TLS connection with the server",
    /* SMTP_STATUS_AUTH */
    "Failed to authenticate with the given credentials",
    /* SMTP_STATUS_SEND */
    "Failed to send bytes to the server",
    /* SMTP_STATUS_RECV */
    "Failed to receive bytes from the server",
    /* SMTP_STATUS_CLOSE */
    "Failed to properly close a connection",
    /* SMTP_STATUS_SERVER_RESPONSE */
    "SMTP server sent back an unexpected status code",
    /* SMTP_STATUS_PARAM */
    "Invalid parameter",
    /* SMTP_STATUS_FILE */
    "Failed to read or open a local file",
    /* SMTP_STATUS_DATE */
    "Failed to get the local date and time",
    /* SMTP_STATUS_SSL */
    "Failure somewhere in SSL/TLS context",
    /* SMTP_STATUS__LAST */
    "Unknown error"
    };

    if ((unsigned)status_code > SMTP_STATUS_LAST)
	status_code = SMTP_STATUS_LAST;
    return status_code_err_str[status_code];
}
