#include "webapp.h"

static void destroySIABHashEntry(void * arg, const char * key, void * value) {
    struct shell_in_a_box_data	* data = value;

    if (data != NULL)
	os_mutex_lock(&data->mutex);
    ZFREE(data);
}

static const char shname[] = "SHELLINABOX";

struct shell_in_a_box_data * getShellHashMap(struct http_server * app) {
    struct shell_in_a_box_data	* data = NULL;

    if (app->srv_data == NULL)
	app->srv_data = new_hash_map(NULL, NULL);
    if (app->srv_data == NULL)
	return data;
    if ((data = get_from_hash_map(app->srv_data, shname)) == NULL) {
	if ((data = initShellInABoxData(data)) != NULL)
	    add_to_hash_map(app->srv_data, shname, data, destroySIABHashEntry);
    }
    return data;
}

struct shell_in_a_box_data * checkAndCreateShellHashMap(struct http_server * app) {
    struct shell_in_a_box_data	* data = getShellHashMap(app);

    if (data != NULL)
	forkLauncher(data);
    return data;
}

struct shell_in_a_box_data * destroyShellHashMap(struct http_server * app) {
    struct shell_in_a_box_data	* data = getShellHashMap(app);

    if (data != NULL) {
	finishAllSessions(data);
	for (int i = 0; i < data->numServices; i++)
	    deleteService(data->services[i]);
	ZFREE(data->services);
	terminateLauncher(data);
	ZFREE(data);
    }
    return data;
}

void finishOutdatedSessions(struct http_server * app) {
    struct shell_in_a_box_data	* data = getShellHashMap(app);

    if (data != NULL) {
	finishOrphanedSessions(data, 900);
    }
}

