// session.h -- Session management for HTTP/HTTPS connections
// Copyright (C) 2008-2009 Markus Gutschke <markus@shellinabox.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// In addition to these license terms, the author grants the following
// additional rights:
//
// If you modify this program, or any covered work, by linking or
// combining it with the OpenSSL project's OpenSSL library (or a
// modified version of that library), containing parts covered by the
// terms of the OpenSSL or SSLeay licenses, the author
// grants you additional permission to convey the resulting work.
// Corresponding Source for a non-source form of such a combination
// shall include the source code for the parts of OpenSSL used as well
// as that of the covered work.
//
// You may at your option choose to remove this additional permission from
// the work, or from any part of it.
//
// It is possible to build this program in a way that it loads OpenSSL
// libraries at run-time. If doing so, the following notices are required
// by the OpenSSL and SSLeay licenses:
//
// This product includes software developed by the OpenSSL Project
// for use in the OpenSSL Toolkit. (http://www.openssl.org/)
//
// This product includes cryptographic software written by Eric Young
// (eay@cryptsoft.com)
//
//
// The most up-to-date version of this program is always available from
// http://shellinabox.com

#ifndef SESSION_H__
#define SESSION_H__

#include <plib/httpserver.h>

#define AJAX_TIMEOUT 45

struct shell_in_a_box_data;

struct Session {
    char	* sessionKey;
    char	* peerName;
    int		done;
    int		pty;
  int              ptyFirstRead;
    int		width;
    int		height;
  int              useLogin;
    pid_t	pid;
    int		cleanup;
    time_t	last_time;
    os_mutex_t	mutex;
    struct shell_in_a_box_data	* data;
    void	* connection;
};

struct Service {
    int		id;
    char	* path;
    BOOL	useLogin;
    BOOL	useHomeDir;
    int		authUser;
    BOOL	useDefaultShell;
  int        uid; /* Can be -1 */
  int        gid; /* Can be -1 */
  char		*user;
  char		*group;
  char		*cwd;
  char		*cmdline;

  char		pid[32];
  int		pty;

};

struct shell_in_a_box_data {
    os_mutex_t		mutex;
    int			numServices;
    int			launcher;
    int			pid;
    uid_t		restricted;
    struct hash_map	* sessions;
    struct Service	** services;
};


void initService(struct Service *service, const char *arg);
struct Service *newService(const char *arg);
void destroyService(struct Service *service);
void deleteService(struct Service *service);
void destroyServiceHashEntry(void *arg, char *key, void *value);
void enumerateServices(struct shell_in_a_box_data * data);


void initSession(struct Session *session, char *sessionKey, const char *peerName, struct shell_in_a_box_data *data);
struct Session *newSession(char *sessionKey, const char *peerName, struct shell_in_a_box_data *data);
void destroySession(struct Session *session);
void deleteSession(struct Session *session);
void abandonSession(struct shell_in_a_box_data * data, struct Session *session);
void finishSession(struct shell_in_a_box_data * data, struct Session *session);
void finishAllSessions(struct shell_in_a_box_data * data);
struct Session *findSession(struct shell_in_a_box_data * data, char *sessionKey, const char *peerName, BOOL *sessionIsNew);
void iterateOverSessions(struct shell_in_a_box_data * data, int (*fnc)(void *, const char *, void **), void *arg);
int  numSessions(struct shell_in_a_box_data * data);
struct shell_in_a_box_data * initShellInABoxData(struct shell_in_a_box_data * data);
void finishOrphanedSessions(struct shell_in_a_box_data * data, int timeout);

#endif /* SESSION_H__ */
