#ifndef P_HTTPINT_H
#define P_HTTPINT_H

#include <plib/http.h>

__BEGIN_DECLS

extern const char	__http_content_disp_str[];
extern const char	__http_cookie_str[];
extern const char	__http_set_cookie_str[];
extern const char	__http_accepted_lang_str[];
extern const char	__http_cache_ctl_str[];
extern const char	* http_error_strings[HTTP_ERR_NUM_ERRS];
extern const char	__http_bnd_str[];
extern const char	__http_ua_str[];
extern const char	__http_from_str[];
extern const char	__http_bnd[];
extern const char	__http_transfer_enc_str[];

const char * http_get_mime_type(const char *, char *, size_t);
char * http_feed_next_part(HTTP_REQUEST *, const char *, BOOL *);
void http_parse_lang(HTTP_REQUEST *);
HTTP_ERROR_CODES http_parse_protocol(HTTP_REQUEST *, const char *);

HTTP_REQUEST * http_create_request(WEB_CONTEXT *, HTTP_ERROR_CODES *);
void http_debug_values(HTTP_REQUEST *, WEB_APP_PLACES);

WEB_CONTEXT *	web_init_ctx_default(void);
WEB_CONTEXT *	web_alloc_ctx(const char *, WEB_APP_MODE, const char *, const char *, int, const char *);
void * web_free_ctx(WEB_CONTEXT *);

int http_lookup_sub_value(char *, size_t, const char *, const char *);

#ifndef HASH_MD5_HEX_LEN
#define HASH_MD5_HEX_LEN (2 * MD5_DIGEST_SIZE)
#endif

/**
 * Maximum length of a username for digest authentication.
 */
#define HTTP_MAX_USERNAME_LENGTH 128

/**
 * Maximum length of a realm for digest authentication.
 */
#define HTTP_MAX_REALM_LENGTH 256

/**
 * Maximum length of the response in digest authentication.
 */
#define HTTP_MAX_AUTH_RESPONSE_LENGTH 128

#define HTTP_MAX_NONCE_LENGTH 129

#define HTTP_STRING_POSSIBLE "abcdefghijkl0123456789mnopqrstuvwxyz"

const char * http_get_digest_nonce_priv_key(void);
void digest_calc_ha1(const char *, const char *, const char *, const char *, const char *, const char *, char *, size_t);
void digest_calc_response(const char *, const char *, const char *, const char *, const char *, const char *, const char *, const char *, char *, size_t);

void http_read_garbage(HTTP_REQUEST *);

size_t http_print_server_cookies(HTTP_REQUEST *, char *, size_t);


__END_DECLS

#endif
