#include "httpint.h"
#include <plib/crypt.h>

static char	NONCE_PRIV_KEY[] = "h5ffku7rlxp6tjf2xamnfqjev5ul";
static int	nonce_priv_key_init = 0;

const char * http_get_digest_nonce_priv_key(void) {

	if (nonce_priv_key_init == 0) {
		size_t	i = 0;
		const char	* possible = HTTP_STRING_POSSIBLE;

		nonce_priv_key_init ++;
		for(i = 0; i < (sizeof(NONCE_PRIV_KEY) - 1); i++)
			NONCE_PRIV_KEY[i] = possible[os_random8() % (sizeof(HTTP_STRING_POSSIBLE) - 1)];
	}
	return (const char *)NONCE_PRIV_KEY;
}

/**
 * Lookup subvalue off of the HTTP Authorization header.
 *
 * A description of the input format for 'data' is at
 * http://en.wikipedia.org/wiki/Digest_access_authentication
 *
 *
 * @param dest where to store the result (possibly truncated if
 *			   the buffer is not big enough).
 * @param size size of dest
 * @param data pointer to the Authorization header
 * @param key key to look up in data
 * @return size of the located value, 0 if otherwise
 */
int http_lookup_sub_value(char * dest, size_t size, const char * data, const char * key) {
	size_t keylen;
	size_t len = 0;
	const char *ptr;

	if (0 == size)
		return 0;
	dest[len] = 0;
	keylen = strlen(key);
	ptr = data;
	while ((ptr = strstr(ptr, key)) != NULL) {
		BOOL	quoted = FALSE;

		ptr += keylen;
		while (('\0' != *ptr) && isspace(*ptr))
			ptr ++;
		if (*ptr != '=')
			continue;
		ptr ++;
		while (('\0' != *ptr) && isspace(*ptr))
			ptr ++;
		if (*ptr == '\"') {
			quoted = TRUE;
			ptr ++;
		}
		while (('\0' != *ptr) && isspace(*ptr))
			ptr ++;
		while (('\0' != *ptr) && (len < size)) {
			if (quoted) {
				if (*ptr == '\"')
					break;
			} else {
				if ((*ptr == ',') || (*ptr == ';'))
					break;
			}
			dest[len++] = *ptr;
			dest[len] = 0;
			ptr ++;
		}
		while ((len > 0) && isspace(dest[len-1])) {
			dest[len-1] = 0;
			len --;
		}
		return (int)len;
	}
	return 0;
}

/**
 * calculate H(A1) as per RFC2617 spec and store the
 * result in 'sessionkey'.
 *
 * @param alg The hash algorithm used, can be "md5" or "md5-sess"
 * @param username A `char *' pointer to the username value
 * @param realm A `char *' pointer to the realm value
 * @param password A `char *' pointer to the password value
 * @param nonce A `char *' pointer to the nonce value
 * @param cnonce A `char *' pointer to the cnonce value
 * @param sessionkey pointer to buffer of HASH_MD5_HEX_LEN+1 bytes
 */
void digest_calc_ha1(const char *alg, const char *username,
		const char *realm, const char *password, const char *nonce,
		const char *cnonce, char *sessionkey, size_t sessionkeylen) {
	P_MD5_CTX	md5;
	unsigned char	ha1[MD5_DIGEST_SIZE];

	P_MD5_Init(&md5);
	P_MD5_Update(&md5,(const unsigned char *) username, strlen(username));
	P_MD5_Update(&md5, (const unsigned char *)":", 1);
	P_MD5_Update(&md5, (const unsigned char *)realm, strlen(realm));
	P_MD5_Update(&md5, (const unsigned char *)":", 1);
	P_MD5_Update(&md5, (const unsigned char *)password, strlen(password));
	P_MD5_Final(ha1, &md5);
	if (0 == strcasecmp(alg, "md5-sess")) {
		P_MD5_Init(&md5);
		P_MD5_Update(&md5, ha1, sizeof(ha1));
		P_MD5_Update(&md5, (const unsigned char *)":", sizeof(char));
		P_MD5_Update(&md5, (const unsigned char *)nonce, strlen(nonce));
		P_MD5_Update(&md5, (const unsigned char *)":", sizeof(char));
		P_MD5_Update(&md5, (const unsigned char *)cnonce, strlen(cnonce));
		P_MD5_Final(ha1, &md5);
	}
	hexify(sessionkey, sessionkeylen, (const char *)ha1, sizeof(ha1));
}

/**
 * Calculate request-digest/response-digest as per RFC2617 spec
 *
 * @param ha1 H(A1)
 * @param nonce nonce from server
 * @param noncecount 8 hex digits
 * @param cnonce client nonce
 * @param qop qop-value: "", "auth" or "auth-int"
 * @param method method from request
 * @param uri requested URL
 * @param hentity H(entity body) if qop="auth-int"
 * @param response request-digest or response-digest
 */
void digest_calc_response(const char *ha1, const char *nonce,
		const char *noncecount, const char *cnonce, const char *qop,
		const char *method, const char *uri, const char *hentity,
		char *response, size_t respsize)
{
	P_MD5_CTX md5;
	unsigned char ha2[MD5_DIGEST_SIZE];
	unsigned char resphash[MD5_DIGEST_SIZE];
	char ha2hex[HASH_MD5_HEX_LEN + 1];

	P_MD5_Init(&md5);
	P_MD5_Update(&md5, (const unsigned char *)method, strlen(method));
	P_MD5_Update(&md5, (const unsigned char *)":", 1);
	P_MD5_Update(&md5, (const unsigned char *)uri, strlen(uri));
	P_MD5_Final(ha2, &md5);
	hexify(ha2hex, sizeof(ha2hex), (const char *)ha2, sizeof(ha2));
	P_MD5_Init(&md5);
	/* calculate response */
	P_MD5_Update(&md5, (const unsigned char *)ha1, HASH_MD5_HEX_LEN);
	P_MD5_Update(&md5, (const unsigned char *)":", 1);
	P_MD5_Update(&md5, (const unsigned char *)nonce, strlen(nonce));
	P_MD5_Update(&md5, (const unsigned char *)":", 1);
	if (!SEMPTY(qop)) {
		P_MD5_Update(&md5, (const unsigned char *)noncecount, strlen(noncecount));
		P_MD5_Update(&md5, (const unsigned char *)":", 1);
		P_MD5_Update(&md5, (const unsigned char *)cnonce, strlen(cnonce));
		P_MD5_Update(&md5, (const unsigned char *)":", 1);
		P_MD5_Update(&md5, (const unsigned char *)qop, strlen(qop));
		P_MD5_Update(&md5, (const unsigned char *)":", 1);
	}
	P_MD5_Update(&md5, (const unsigned char *)ha2hex, HASH_MD5_HEX_LEN);
	P_MD5_Final(resphash, &md5);
	hexify(response, respsize ,(const char *)resphash, sizeof(resphash));
}
