#include <plib/httpclient.h>
#include "../httpint.h"

HTTP_ERROR_CODES http_parse_and_filter_cookie(HTTP_REQUEST *, char *);

HTTP_ERROR_CODES http_parse_and_filter_cookie(HTTP_REQUEST * http, char * cookie) {
    char	* subvalue, buf[ASCIILINESZ];

    if (SEMPTY(cookie)) {
	/* no cookies */
	log_debug(http_error_strings[HTTP_ERR_NO_COOKIES]);
	return HTTP_ERR_NONE;
    }
    /* Seek and filter for Domain value */
    if ((http->uri != NULL) && (http->uri->uri_host != NULL) &&((subvalue = strstr(cookie, "omain=")) != NULL)) {
	char	* subptr;

	subvalue += 6;
	if ((subptr = strchr(subvalue, ';')) != NULL) {
	    memcpy(buf, subvalue, MIN(sizeof(buf), subptr - subvalue));
	    buf[subptr - subvalue] = 0;
	} else {
	    strncpy(buf, subvalue, sizeof(buf));
	}
	strstrip(buf, sizeof(buf), buf);
	if (strcmp(http->uri->uri_host, subvalue) != 0)
	    return HTTP_ERR_NONE;
    }
    if ((subvalue = strstr(cookie, "xpires=")) != NULL) {
	char	* subptr;
	struct tm	tm;
	time_t	curtime = time(NULL);

	memset(&tm, 0, sizeof(tm));
	subvalue += 7;
	if ((subptr = strchr(subvalue, ';')) != NULL) {
	    memcpy(buf, subvalue, MIN(sizeof(buf), subptr - subvalue));
	    buf[subptr - subvalue] = 0;
	} else {
	    strncpy(buf, subvalue, sizeof(buf));
	}
	strstrip(buf, sizeof(buf), buf);
	strptime(subvalue, "%a, %d-%b-%Y %H:%M:%S %Z", &tm);
	if (mktime(&tm) <= curtime)
	    return HTTP_ERR_NONE;
    }
    if ((subvalue = strchr(cookie, ';')) != NULL)
	*subvalue = 0;
    if (http->req_cookies == NULL) {
	if ((http->req_cookies = val_new("cookies")) == NULL)
	    return HTTP_ERR_OUT_OF_MEMORY;
    }
    if (val_from_key_value(cookie, http->req_cookies, TRUE) == NULL)
	return HTTP_ERR_OUT_OF_MEMORY;
    return HTTP_ERR_NONE;
}
