#include <plib/httpclient.h>

static void usage(const char * progname) {
    fprintf(stderr, "Usage: %s [-d] [-k] [-c CONNECTION_TIMEOUT] [-o|-O FILNAME] URL\n", progname);
    exit(-1);
}

static char *prog_name;

int main(int argc, char ** argv) {
    WEB_CONTEXT	* app;
    int		ch, options = 0, ret = -1;
    long	connection_timeout = 30;
    char	* target = NULL;
    pstream_t	* stream = NULL;

    prog_name = basename(argv[0]);

    if (argc < 2)
	usage(prog_name);

    while ((ch = getopt(argc, argv, "dko:O:")) != -1) {

        switch (ch) {
            case 'd':
		options |= WEB_CLIENT_OPT_DEBUG;
		log_open(prog_name, 15);
                break;
            case 'k':
		options |= WEB_CLIENT_OPT_SSL_VERIFY;
                break;
            case 'c':
		connection_timeout = atol(optarg);
                break;
            case 'O':
            case 'o':
		stream = pstream_init(optarg, -1, NULL, 0);
                break;
            default:
		usage(prog_name);
		break;
        }
    }

    if (argc - optind == 1) {
        target = argv[optind];
    }

    if (SEMPTY(target))
	usage(prog_name);



    if ((app = http_client_get(target, NULL, NULL, options, stream, NULL, NULL, connection_timeout)) != NULL) {
	fprintf(stderr, "\nRequest %s has been completed in %lu ms with code %d\n", target, (unsigned long)app->http->elapsed, app->http->retcode);
	web_cleanup_ctx(app);
	ret = 0;
    }
    if (stream != NULL) {
	pstream_close(stream);
	ZFREE(stream);
    }
    return ret;
}
