#include <plib/httpserver.h>
#include <plib/osutil.h>
#include <plib/template.h>

static BOOL validate_access(const char * uname, const char * passwd) {
    BOOL	res = FALSE;

    if (!SEMPTY(uname) && !SEMPTY(passwd)) {
	os_user_t	* pwe = NULL;
	
	if ((pwe = os_get_user_data( uname, -1L)) != NULL) {
	    size_t	sz = strlen( pwe->passwd);
	    char	* np = crypt(passwd, pwe->passwd);
	    
	    res = (BOOL)(strncmp( pwe->passwd, np, sz) == 0);
	    ZFREE((void *)pwe);
	}
    }
    return res;
}

static BOOL validate_token(long uid, const char * token) {
    BOOL	res = FALSE;
    char	* words[4];

    if (!SEMPTY(token)) {
	os_user_t	* pwe = NULL;
	
	if ((pwe = os_get_user_data(NULL, uid)) != NULL) {
	    size_t	i;
	    size_t	sz = 4;

	    split((const char *)pwe->passwd, words, &sz, "$");
	    if ( sz > 0) {
		res = (BOOL)(strncmp( words[sz-1], token, strlen(token)) == 0);
		for ( i = 0; i < sz; i++)
		    ZFREE(words[i]);
	    }
	    ZFREE((void *)pwe);
	}
    }
    return res;
}

static char cookie_name[] = "SSXAPP";
static char tkn_name[] = "TKN";

static val_t * find_token_value(HTTP_REQUEST * http) {
    val_t * tkn = dict_find_node(http->req_cookies, cookie_name);

    if (tkn == NULL)
	tkn = dict_find_node(http->request, tkn_name);
    return tkn;
}

static BOOL validate(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* tkn;

    if ((http == NULL) || (http->app == NULL))
	return res;

    http->app->validated_level = 0;

    if ((tkn = find_token_value(http)) != NULL) {
	const char	* ptr = val_as_str_ptr(tkn);

	if (!SEMPTY(ptr)) {
	    size_t	i, sz = 8;
	    char	* words[8];

	    split(ptr, words, &sz, "=");
	    if (sz >= 3) {
		char	* d[8];
		long	uid = str2long(words[1]);
		size_t	real_sz = 8;

		split((const char *)words[2], d, &real_sz, "$");
		if (real_sz > 0)
		    res = validate_token(uid, d[real_sz-1]);
		for (i = 0; i < real_sz; i++)
		    ZFREE(d[i]);
	    }
	    for (i = 0; i < sz; i++)
		ZFREE(words[i]);
	}
    } else {
	/* TKN is empty. So we check USERNAME and PASSWORD variables */
    }
    if (res)
	http->app->validated_level = 99;
    return res;
}

DECLARE_PLUGIN(sys)
PLUGIN_METHOD(validate)
END_PLUGIN(sys)
