#include <plib/httpserver.h>
#include <plib/license.h>

static BOOL validate_token(const char * token) {
    BOOL	res = FALSE;

    if (!SEMPTY(token)) {
	char id[VAL_KEY_LEN];

	get_dev_id_str(id, sizeof(id), NULL);
	res = (BOOL)(strstr(id, token) != NULL);
    }
    return res;
}

static char cookie_name[] = "SSXAPP";
static char tkn_name[] = "TKN";

static val_t * find_token_value(HTTP_REQUEST * http) {
    val_t * tkn = dict_find_node(http->req_cookies, cookie_name);

    if (tkn == NULL)
	tkn = dict_find_node(http->request, tkn_name);
    return tkn;
}

static BOOL validate(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* tkn;

    if ((http == NULL) || (http->app == NULL))
	return res;

    http->app->validated_level = 0;

    if ((tkn = find_token_value(http)) != NULL) {
	const char	* ptr = val_as_str_ptr(tkn);

	if (!SEMPTY(ptr)) {
	    size_t	i, sz = 8;
	    char	* words[8];

	    split(ptr, words, &sz, "=");
	    if (sz >= 6)
		res = validate_token(words[5]);
	    if (res && (sz >= 7))
		http->privdata = ZSTRDUP(words[7]);
	    for (i = 0; i < sz; i++)
		ZFREE(words[i]);
	}
    } else {
	/* TKN is empty. So we check USERNAME and PASSWORD variables */
    }
    if (res)
	http->app->validated_level = 99;
    return res;
}

DECLARE_PLUGIN(cauth)
PLUGIN_METHOD(validate)
END_PLUGIN(cauth)
