#include <plib/httpserver.h>
#include <plib/fs.h>
#include <plib/conf.h>
#include <plib/osutil.h>
#include <plib/license.h>
#include <plib/utils.h>

static blob_t * blob_pack_code(int code, val_t * data) {
	blob_t	* blob = blob_new();

	if (blob != NULL) {
		if (code != 0) {
			blob_printf(blob, "{\"code\":\"%d\",\"message\":\"Something is going wrong\"}", code);
		} else {
			if (data != NULL) {
				blob_t	* b = val_2_blob(data, NULL, VAL_C_TYPE_JSON, -1);

				if (b != NULL) {
					blob_rewind(b);
					blob_printf(blob, "{\"code\":\"%d\",\"data\":\"%s\"}", code, (const char *)blob_data(b));
					blob_free(b);
				} else {
					blob_free(blob);
					blob = NULL;
				}
			} else {
				blob_printf(blob, "{\"code\":\"%d\",\"message\":\"Ok\"}", code);
			}
		}
	}
	return blob;
}

static blob_t * submit_nms(val_t * cfg) {
	write_simple_event("nms %s", "submit");
	return blob_pack_code(0, NULL);
}

static blob_t * cfg_rst(val_t * cfg) {
	write_simple_event("nms %s", "cfg_reset");
	return blob_pack_code(0, NULL);
}

static blob_t * cfg_upl(val_t * cfg) {
	write_simple_event("exec %s", "/opt/stasoft/bin/cfg_upload.sh");
	return blob_pack_code(0, NULL);
}

static blob_t * cfg_back(val_t * cfg) {
	write_simple_event("exec %s", "/opt/stasoft/bin/cfg_download.sh");
	return blob_pack_code(0, NULL);
}

static blob_t * frmw_upd(val_t * cfg) {
	write_simple_event("exec %s", "/opt/stasoft/bin/fw_upgrade.sh");
	return blob_pack_code(0, NULL);
}

static blob_t * reboot(val_t * cfg) {
	write_simple_event("exec %s", "reboot");
	return blob_pack_code(0, NULL);
}

static blob_t * ch_pwd(val_t * data) {
	BOOL	res = FALSE;
	val_t	* node = dict_find_node_near(data, "password", TRUE);

	if (node != NULL) {
		char	* ptr = val_as_str_simple(node);

		if (!SEMPTY(ptr))
			res = user_changepw("root", ptr);
		ZFREE(ptr);
	}
	node = dict_find_node_near(data, "sup_password", TRUE);
	if (node != NULL) {
		char	* ptr = val_as_str_simple(node);

		if (!SEMPTY(ptr))
			res = user_changepw("superuser", ptr);
		ZFREE(ptr);
	}
	node = dict_find_node_near(data, "hostname", TRUE);
	if (node != NULL) {
		char	* ptr = val_as_str_simple(node);

		if (!SEMPTY(ptr))
			res = write_simple_event("setval services:hostname  %s", ptr);
		ZFREE(ptr);
	}
	if (res) {
		char	id[VAL_KEY_LEN];

		id[0] = 0;
		get_dev_id_str(id, sizeof(id), NULL);
		if (SEMPTY(id))
			snprintf(id, sizeof(id), "%llu", (unsigned long long)time(NULL));
		res = write_simple_event("setval PRIVATE_KEY %s", id);
	}
	return blob_pack_code((res ? 0 : -1), NULL);
}

struct jsrpc_method {
	const char	* name;
	blob_t *	(*func)(val_t *);
	BOOL		direct_call_possible;
};

static const struct jsrpc_method methods[] = {
	{ "submit_radio", submit_nms, TRUE },
	{ "submit_nms", submit_nms, TRUE },
	{ "cfg_rst", cfg_rst, TRUE },
	{ "cfg_upl", cfg_upl, TRUE },
	{ "cfg_back", cfg_back, TRUE },
	{ "frmw_upd", frmw_upd, TRUE },
	{ "reboot", reboot, TRUE },
	{ "ch_pwd", ch_pwd, FALSE },
	{ NULL, NULL, FALSE }
};

static blob_t * on_set(val_t * cfg, val_t * data, const char * method, val_t * addarr) {
    blob_t	* blob = NULL;
    val_t	* larr = (SEMPTY(method) ? data : addarr);

    if (V_IS_OBJ(larr) || V_IS_ARR(larr)) {
	if (SEMPTY(method) && (V_IS_OBJ(larr) || V_IS_ARR(larr)))
	    cfg = dict_merge(cfg, larr);
	else
	    cfg = larr;
	cfg_write_file_ex(SYS_SCHEME_CONFIG_FILE, cfg);
    }
    if (sched_install_job("root", "{\"0\":\"*/5\",\"1\":\"*\",\"2\":\"*\",\"4\":\"*\",\"4\":\"*\".\"5\":\"/opt/stasoft/bin/nms-heartbeat.sh\"}"))
	sched_restore_jobs();
    if (!SEMPTY(method)) {
	int	i = 0;

	while ((methods[i].name != NULL) && (strcmp(methods[i].name, method) != 0))
	    i ++;
	if (methods[i].func != NULL)
	    blob = (*methods[i].func)(data);
    } else
	blob = blob_pack_code(0, NULL);
    return blob;
}

static blob_t * on_get(val_t * cfg, val_t * arr) {
	blob_t	* blob = NULL;
	val_t	* new_arr = dict_find_path(cfg, arr);

	if (new_arr != NULL) {
		blob_pack_code(0, new_arr);
		val_free(new_arr);
	}
	return blob;
}

static BOOL exec(HTTP_REQUEST * http) {
    BOOL	res = FALSE;

    if ((http == NULL) || (http->app == NULL) || ((http->method != HTTP_REQ_POST) && (http->method != HTTP_REQ_GET)))
	return res;

    http->validator = "cauth";

    if (web_request_validate(http)) {
	val_t	* cfg;

	if ((cfg = parse_jsonfile(SYS_CONFIG_FILE)) != NULL) {
	    char	* method = NULL;
	    blob_t	* blob = NULL;
	    val_t	* data = dict_find_node_near(http->request, "data", TRUE), * addarr = NULL;

	    if (data != NULL) {
		char	* ptr = val_as_str_simple(data);

		data = parse_jsonstr(ptr);
		ZFREE(ptr);
	    }
	    switch (http->method) {
		case HTTP_REQ_GET:
		    if (data != NULL)
			blob = on_get(cfg, data);
		break;
		case HTTP_REQ_POST:
		    if (data != NULL) {
			val_t	* v = dict_find_node_near(http->request, "method", TRUE);

			if (v != NULL)
			    method = val_as_str_simple(v);
			if ((v = dict_find_node_near(http->request, "cfg", TRUE)) != NULL) {
			    char	* ptr = val_as_str_simple(v);

			    addarr = parse_jsonstr(ptr);
			    ZFREE(ptr);
			}
			blob = on_set(cfg, data, method, addarr);
			val_free(addarr);
		    }
		break;
		default:
		break;
	    }
	    if ((data == NULL) && (blob == NULL)) {
		int	i = 0;

		method = ZSTRDUP(http->privdata);
		if (!SEMPTY(method)) {
		    while ((methods[i].name != NULL) && (strcmp(methods[i].name, method) != 0))
			i ++;
		    if ((methods[i].func != NULL) && methods[i].direct_call_possible)
			blob = (*methods[i].func)(cfg);
		}
	    }
	    ZFREE(method);
	    if (data != NULL)
		val_free(data);
	    if (blob != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    val_free(cfg);
	}
    }

    return res;
}

DECLARE_PLUGIN(jsrpc)
PLUGIN_METHOD(exec)
END_PLUGIN(jsrpc)
