#include <plib/httpserver.h>
#include <plib/osutil.h>
#include <plib/fs.h>
#include <plib/exec.h>

static BOOL syslog(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;
    val_t	* root;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((root = fs_get_file_as_array("/var/log/messages")) != NULL) {
	if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
	    blob_rewind(blob);
	    res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	    blob_free(blob);
	}
	val_free(root);
    }
    return res;
}

static BOOL dmesg(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    char	* ftmp;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((ftmp = fs_tmp_name(NULL, NULL, 0)) != NULL) {
	val_t	* root;

	os_system("dmesg > %s", ftmp);
	if ((root = fs_get_file_as_array(ftmp)) != NULL) {
	    blob_t	* blob;

	    if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    val_free(root);
	}
	fs_remove(ftmp);
	ZFREE(ftmp);
    }
    return res;
}

static BOOL disks(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = os_get_diskinfo_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL mem(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = os_sysinfo_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL cpu(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = os_get_cpu_load_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

DECLARE_PLUGIN(sysinfo)
PLUGIN_METHOD(dmesg)
PLUGIN_METHOD(syslog)
PLUGIN_METHOD(disks)
PLUGIN_METHOD(mem)
PLUGIN_METHOD(cpu)
END_PLUGIN(sysinfo)
