#include <plib/httpserver.h>
#include <plib/exec.h>
#include <plib/net.h>

static BOOL ping(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;
    char	* ptr;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node_near(http->request, "host", TRUE)) == NULL)
	return res;
    if ((ptr = val_as_str_simple(node)) != NULL) {
	blob_t	* blob = NULL;
	if ((blob = os_exec_as_json( "mbwping", ptr)) != NULL) {
	    blob_rewind(blob);
	    res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	    blob_free(blob);
	}
	ZFREE( ptr);
    }
    return res;
}

static BOOL tracert(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;
    char	* ptr;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;
    if ((node = dict_find_node_near(http->request, "host", TRUE)) == NULL)
	return res;

    if ((ptr = val_as_str_simple(node)) != NULL) {
	blob_t	* blob = NULL;
	char	buf[1024];

	snprintf(buf, sizeof(buf), "45 traceroute %s", ptr);
	ZFREE( ptr);
	if ((blob = os_exec_as_json("timeout", buf)) != NULL) {
	    blob_rewind(blob);
	    res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	    blob_free(blob);
	}
    }
    return res;
}

static BOOL dhcpd_leases(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = dhcpd_leases_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL netstat(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = netstat_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL arp(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = arp_info_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL route(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = route_info_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL netdata(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = if_net_speed_info_as_json()) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL ifdata(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "ifname")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob;

	    if ((blob = if_calc_speed( ptr)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    ZFREE(ptr);
	}
    }
    return res;
}

static BOOL radiodata(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "ifname")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob;

	    if ((blob = radio_calc_param( ptr)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    ZFREE(ptr);
	}
    }
    return res;
}

static BOOL survey(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "ifname")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob;

	    if ((blob = radio_survey_dump( ptr)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL station(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;


    if ((node = dict_find_node(http->request, "ifname")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if ( ptr != NULL) {
	    blob_t	* blob;

	    if ((blob = radio_station_dump( ptr)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL fw4state(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    char	* ftmp;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((ftmp = fs_tmp_name(NULL, NULL, 0)) != NULL) {
	val_t	* root;

	os_system("iptables -vL > %s", ftmp);
	os_system("iptables -t nat -vL >> %s", ftmp);
	os_system("iptables -t mangle -vL >> %s", ftmp);
	if ((root = fs_get_file_as_array(ftmp)) != NULL) {
	    blob_t	* blob;

	    if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    val_free(root);
	}
	fs_remove(ftmp);
	ZFREE(ftmp);
    }
    return res;
}

static BOOL fw6state(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    char	* ftmp;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((ftmp = fs_tmp_name(NULL, NULL, 0)) != NULL) {
	val_t	* root;

	os_system("ip6tables -vL > %s", ftmp);
	os_system("ip6tables -t nat -vL >> %s", ftmp);
	os_system("ip6tables -t mangle -vL >> %s", ftmp);
	if ((root = fs_get_file_as_array(ftmp)) != NULL) {
	    blob_t	* blob;

	    if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    val_free(root);
	}
	fs_remove(ftmp);
	ZFREE(ftmp);
    }
    return res;
}

static BOOL qosstate(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    char	* ftmp;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((ftmp = fs_tmp_name(NULL, NULL, 0)) != NULL) {
	val_t	* root;

	os_system("tc class show > %s", ftmp);
	os_system("tc qdisc show >> %s", ftmp);
	os_system("tc filter show >> %s", ftmp);
	if ((root = fs_get_file_as_array(ftmp)) != NULL) {
	    blob_t	* blob;

	    if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    val_free(root);
	}
	fs_remove(ftmp);
	ZFREE(ftmp);
    }
    return res;
}

static BOOL ebstate(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    char	* ftmp;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((ftmp = fs_tmp_name(NULL, NULL, 0)) != NULL) {
	val_t	* root;

	os_system("ebtables -L > %s", ftmp);
	if ((root = fs_get_file_as_array(ftmp)) != NULL) {
	    blob_t	* blob;

	    if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free(blob);
	    }
	    val_free(root);
	}
	fs_remove(ftmp);
	ZFREE(ftmp);
    }
    return res;
}

static BOOL dnsstate(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* root;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((root = fs_get_file_as_array("/tmp/resolv.conf.auto")) != NULL) {
	blob_t	* blob;

	if ((blob = val_2_blob(root, NULL, VAL_C_TYPE_JSON, 0)) != NULL) {
	    blob_rewind(blob);
	    res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	    blob_free(blob);
	}
	val_free(root);
    }
    return res;
}

static BOOL bports(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob;

    if ((blob = os_exec_as_json("bridge", "-s link show")) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL bmdbs(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob;

    if ((blob = os_exec_as_json("bridge", "-s mdb show")) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL bfdbs(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob;

    if ((blob = os_exec_as_json("bridge", "-s fdb show")) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL bvlans(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob;

    if ((blob = os_exec_as_json("bridge", "-s vlan show")) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

static BOOL bmcast(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob;

    if ((blob = os_exec_as_json("ip", "xstats type bridge")) != NULL) {
	blob_rewind(blob);
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
    return res;
}

DECLARE_PLUGIN(net)
PLUGIN_METHOD(dhcpd_leases)
PLUGIN_METHOD(netstat)
PLUGIN_METHOD(ping)
PLUGIN_METHOD(tracert)
PLUGIN_METHOD(arp)
PLUGIN_METHOD(route)
PLUGIN_METHOD(netdata)
PLUGIN_METHOD(ifdata)
PLUGIN_METHOD(radiodata)
PLUGIN_METHOD(survey)
PLUGIN_METHOD(station)
PLUGIN_METHOD(fw4state)
PLUGIN_METHOD(fw6state)
PLUGIN_METHOD(qosstate)
PLUGIN_METHOD(ebstate)
PLUGIN_METHOD(dnsstate)
PLUGIN_METHOD(bports)
PLUGIN_METHOD(bvlans)
PLUGIN_METHOD(bfdbs)
PLUGIN_METHOD(bmdbs)
PLUGIN_METHOD(bmcast)
END_PLUGIN(net)
