#include <plib/httpserver.h>
#include <plib/exec.h>

static BOOL exec(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;
    char	* ptr;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node_near(http->request, "host", TRUE)) == NULL)
	return res;
    if ((ptr = val_as_str_simple(node)) != NULL) {
	blob_t	* blob = NULL;
	char	* params = NULL;
	size_t	i;
		
	for(i = 0; i < strlen(ptr); i++)
	    if (ptr[i] == ' ') {
		ptr[i] = 0;
		params = (char *)(ptr+i+1);
		break;
	}
	if ((blob = os_exec_as_json( ptr, params)) != NULL) {
		blob_rewind(blob);
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	}
	ZFREE( ptr);
    }
    return res;
}

DECLARE_PLUGIN(cmd)
PLUGIN_METHOD(exec)
END_PLUGIN(cmd)
