#ifndef P_HTTPSERVER_H
#define P_HTTPSERVER_H

#include <plib/thread.h>
#include <plib/http.h>

typedef HTTP_ERROR_CODES (*WEB_METHOD)(HTTP_REQUEST *);
typedef int (*WEB_AUTH_METHOD)(const PEER_ADDR *, const PEER_ADDR *, const char *, const char *, void *);

struct http_auth {
    int			timeout;
    char		realm[VAL_KEY_LEN];
    char		username[VAL_KEY_LEN];
    char		password[VAL_KEY_LEN];
    void		* data;
    WEB_AUTH_METHOD	handler;
};

struct http_cgi {
    int			timeout;
    char		directory[MAXPATHLEN];
    char		pattern[VAL_KEY_LEN];
};

TAILQ_HEAD(http_requests, http_request);

struct http_server {
    WEB_APP_MODE	mode;
    HTTP_REQUEST_TYPE	method_mask;
    HTTP_PROTO_TYPE	proto_mask;
    WEB_LANG		lang;
    WEB_CONTEXT		* http_ctx;
    WEB_CONTEXT		* https_ctx;
    struct peer_addrs	peer_addrs;
    BOOL		external_watcher;
    POLL_T		* pfd;
    int			connection_timeout;
    int			poolsize;
    int			uid;
    int			gid;
    os_thpool_t		* thpool;
    const char		* servername;
    const char		* indexes;
    char		sysuser[VAL_KEY_LEN];
    char		sysgroup[VAL_KEY_LEN];
    char		domain[VAL_KEY_LEN];
    char		ciphers[VAL_KEY_LEN];
    char		certificate[MAXPATHLEN];
    char		webroot[MAXPATHLEN];
    char		pidfile[MAXPATHLEN];
    struct http_auth	auth_data;
    struct http_cgi	cgi_data;
    struct hash_map	* srv_data;
};

__BEGIN_DECLS

PLEX HTTP_ERROR_CODES http_server_send_indication(HTTP_REQUEST *, HTTP_ERROR_CODES);
PLEX HTTP_REQUEST * http_server_read_request(WEB_CONTEXT *, struct pstream_t *, BOOL);
PLEX void http_server_add_pending_request(HTTP_REQUEST *);
PLEX void http_server_send_release_msg(HTTP_REQUEST *, HTTP_ERROR_CODES);

PLEX WEB_CONTEXT * web_init(const char *, const char *, const char *, const char *, const char *, WEB_LANG, const char *, const char *);
PLEX HTTP_ERROR_CODES web_exec(WEB_CONTEXT *, SOCK_T);

PLEX HTTP_ERROR_CODES http_server_check_auth(HTTP_REQUEST *);

PLEX BOOL http_write_body_blob(HTTP_REQUEST *, const char *, blob_t *);
PLEX void http_server_send_redirect(HTTP_REQUEST *, const char *);

PLEX SOCK_EV_ACTIONS web_server_exec(PEER_ADDR *);
PLEX BOOL http_server_run(struct http_server *, int *);
PLEX void http_server_destroy(struct http_server *);

PLEX BOOL http_server_config(struct http_server *, int, int, const char *, const char *, const char *, const char *, WEB_LANG);
PLEX BOOL http_server_add_listener(struct http_server *, struct addr *, uint16_t, BOOL);
PLEX BOOL http_server_add_listener_any(struct http_server *, uint16_t, BOOL);
PLEX BOOL http_server_add_auth(struct http_server *, WEB_APP_MODE, const char *, const char *, const char *, void *, WEB_AUTH_METHOD, int);
PLEX BOOL http_server_add_ssl(struct http_server *, const char *, const char *);
PLEX BOOL http_server_add_debug(struct http_server *, BOOL);
PLEX BOOL http_server_add_cgi(struct http_server *, const char *, const char *, int);
PLEX BOOL http_server_add_masks(struct http_server *, HTTP_PROTO_TYPE, HTTP_REQUEST_TYPE);
PLEX BOOL http_server_add_runinfo(struct http_server *, const char *, const char *, const char *);

PLEX BOOL http_server_add_cookie(HTTP_REQUEST *, const char *, const char *, const char *, time_t, BOOL);

PLEX HTTP_ERROR_CODES http_server_execute(HTTP_REQUEST *);
PLEX char * http_get_peername(HTTP_REQUEST *);
PLEX BOOL web_request_validate(HTTP_REQUEST *);

__END_DECLS

#endif
