#ifndef	_PLIBCURL_H
#define	_PLIBCURL_H
#include <plib/uri.h>

typedef enum {
    PCURL_USE_STREAM_LOCAL_WRITE = 0x1,
    PCURL_USE_STREAM_LOCAL_READ = 0x2,
    PCURL_HTTP_REQUEST = 0x4,
    PCURL_SMTP_REQUEST = 0x8,
    PCURL_FTP_REQUEST = 0x10,
    PCURL_UPLOAD_REQUEST = 0x20,
    PCURL_WRITE_TO_BLOB = 0x40,
    PCURL_VERIFY_PEER = 0x80,
} REQ_CTX_FLAGS;

#ifdef HAVE_CURL_LIB
#ifdef HAVE_CURL_H
#include <curl.h>
#endif
#ifdef HAVE_CURL_CURL_H
#include <curl/curl.h>
#endif

typedef struct pcurl_ctx {
    REQ_CTX_FLAGS	options;
    long		timeout;
    long		connection_timeout;
    const char		* orig_url;
    const char		* ua;
    const char		* ca;
    CURL		* curl;
    blob_t		* blob;
    int			retcode;
    long		response_code;
    double		elapsed;
    struct uri_t	* uri;
    char		* url;
    pstream_t		* stream;
    void		* header_data;
    void		* post_data;
} pcurl_ctx;

#else
#include <plib/httpclient.h>

typedef	WEB_CONTEXT	pcurl_ctx;
#endif

__BEGIN_DECLS

PLEX pcurl_ctx * pcurl_http_get(const char *, const val_t *, const val_t *, int, 
				pstream_t *, const char *, const char *, long, long);
PLEX pcurl_ctx * pcurl_http_post(const char *, const val_t *, const val_t *, int, 
				pstream_t *, const char *, const char *, long, long);
PLEX pcurl_ctx * pcurl_finalize(pcurl_ctx *);

PLEX BOOL download_file( const char *, const char *, int);
PLEX BOOL upload_file( const char *, const char *, int);
PLEX BOOL smtp_send_blob(const char *, const char *, const char *,  const char *, const char *, const char *, const blob_t *);
PLEX BOOL smtp_file(const char *, const char *, const char *,  const char *, const char *, const char *, const char *, BOOL);

__END_DECLS

#endif
