/*
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *	HTTP digest auth functions: originally imported from libmicrohttpd
 *
 *	Copyright (C) 2012-2014 PIVA SOFTWARE (www.pivasoftware.com)
 *		Author: Oussama Ghorbel <oussama.ghorbel@pivasoftware.com>
 *
 */


#ifndef DIGESTAUTH_H_
#define DIGESTAUTH_H_

#define OPAQUE "328458fab28345ae87ab3210a8513b14eff452a2"

/**
 * MHD digest auth internal code for an invalid nonce.
 */
#define MHD_INVALID_NONCE -1
#include <plib/httpserver.h>

__BEGIN_DECLS

HTTP_ERROR_CODES http_digest_auth_fail_response(HTTP_REQUEST *, const char *);
int http_digest_auth_check(HTTP_REQUEST *, const char *, unsigned int);

__END_DECLS

#endif /* DIGESTAUTH_H_ */
