#include <plib/httpserver.h>
#include "../httpint.h"

HTTP_ERROR_CODES http_parse_cookies(HTTP_REQUEST *, const char *);

HTTP_ERROR_CODES http_parse_cookies(HTTP_REQUEST * ctx, const char * cookie) {

    if (SEMPTY(cookie)) {
	/* no cookies */
	log_debug(http_error_strings[HTTP_ERR_NO_COOKIES]);
	return HTTP_ERR_NONE;
    }
    if (ctx->req_cookies == NULL) {
	if ((ctx->req_cookies = val_new("cookies")) == NULL)
	    return HTTP_ERR_OUT_OF_MEMORY;
    }
    do {
	char	* pair;

	cookie = pat_tokenize(cookie, ";", &pair);
	if (!SEMPTY(pair)) {

	    if (val_from_key_value(pair, ctx->req_cookies, TRUE) == NULL) {
		ZFREE(pair);
		return HTTP_ERR_OUT_OF_MEMORY;
	    }
	}
	ZFREE(pair);
    } while (cookie != NULL);
    return HTTP_ERR_NONE;
}

PLEX BOOL http_server_add_cookie(HTTP_REQUEST * http, const char * name, const char * value, const char * domain, time_t expires, BOOL httponly) {
    BOOL		res = FALSE;
    HTTP_SERVER_COOKIE	* cookie;
    val_t		* val = val_new(name);

    if (val != NULL) {
	val_from_str(val, value);
	if ((cookie = ZALLOC(sizeof(*cookie))) != NULL) {
	    if (!SEMPTY(domain)) {
		if ((cookie->domain = ZSTRDUP(domain)) != NULL) {
		    cookie->value = val;
		    cookie->expires = expires;
		    cookie->httponly = httponly;
		    TAILQ_INSERT_TAIL(&http->resp_cookies, cookie, entry);
		    res = TRUE;
		} else {
		    val_free(val);
		    ZFREE(cookie);
		}
	    }
	} else {
	    val_free(val);
	}
    }
    return res;
}
