V1

/* Assume that ctx->ptr has adjusted to start of POST body and eof is set if whole request has been read already */
static HTTP_ERROR_CODES parse_data_multipart(HTTP_REQUEST * ctx, const char * content_type, val_t * parent) {
    char	* ptr, * cptr;
    BOOL	eof = FALSE;
    char	boundary[512], filename[512];
    val_t	* node = NULL;
    size_t	len;

    ctx->content_type = HTTP_TYPE_MULTIPART_FORM_DATA;
    /* Determine the boundary string: */
    if ((ptr = strstr(content_type, __http_bnd_str)) == NULL)
	return HTTP_ERR_NO_BOUNDARY;
    ptr += strlen(__http_bnd_str);
    while (*ptr == '"')
	ptr ++;
    memset((void *)boundary, 0, sizeof(boundary));
    strncpy(boundary, __http_lf, sizeof(boundary));
    strncpy(boundary + 2, __http_bnd, sizeof(boundary) - 2);
    cptr = boundary + strlen(__http_bnd)+ 2;
    while ((*ptr != '\0') && (*ptr != '\r') && (*ptr != '\n') && (*ptr != '"'))
	*(cptr ++) = *(ptr ++);
    log_info("Boundary - %s", boundary + 2);
    len = strlen(boundary);
    blob_seek(ctx->body, -2, SEEK_CUR);
    memcpy(blob_data(ctx->body), __http_lf, 2);
    /* Read in until there's no more: */
    while (TRUE) {

	cptr = http_feed_next_part(ctx, boundary, &eof);


	if (cptr == NULL) {
	    if (eof || !V_IS_FILE(node)) {
		if (parent != NULL)
		    val_free(parent);
		return HTTP_ERR_BAD_REQUEST;
	    }
	    fs_add_contents_simple(val_file_get_name(node), blob_data(ctx->body), blob_left(ctx->body));
	} else {
	    char	* ccd;

	    /* We got a boundary! */
	    if (node != NULL) {
		*cptr = 0;
		if (V_IS_FILE(node)) {
		    fs_add_contents_simple(val_file_get_name(node), blob_data(ctx->body), cptr - (char *)blob_data(ctx->body));
		} else {
		    ptr = url_decode(NULL, 0, (const char *)blob_data(ctx->body), strlen((const char *)blob_data(ctx->body)));
		    val_from_str(node, ptr);
		    ZFREE(ptr);
		}
		if (cptr[len+1] == '-') {
		    blob_seek(ctx->body , (cptr - (char *)blob_data(ctx->body)) + len + 2, SEEK_CUR);
		    /* We reach end of form! */
		    return HTTP_ERR_NONE;
		}
	    }
	    blob_seek(ctx->body , (cptr - (char *)blob_data(ctx->body)) + len + 2, SEEK_CUR);
	    if ((cptr = http_feed_next_part(ctx, __http_hdr_end, &eof)) == NULL) {
		return HTTP_ERR_BAD_REQUEST;
	    }
	    *cptr = 0;
	    cptr += 4; 
	    /* We should be at value or at included envelope at this moment */
	    /* We had just got a boundary, read headers: */
	    /* What kind of header is it? */
	    if ((ptr = strstr((char *)blob_data(ctx->body), __http_content_disp_str)) == NULL) {
		return HTTP_ERR_BAD_REQUEST;
	    }
	    ccd = ptr;
	    /* Content-disposition: */
	    filename[0] = 0;
	    /* Check for filename field */
	    if ((ptr = strstr(ptr, "filename=\"")) != NULL) {
		ptr += 10;
	    } else {
		ptr = ccd;
		if ((ptr = strstr(ptr, "file=\"")) != NULL)
		    ptr += 6;
	    }
	    if (ptr != NULL) {
		char	* tgt = filename;
		while ((tgt < (filename + sizeof(filename))) && (*ptr != '\0') && (*ptr != '"') && (*ptr != '\r') && (*ptr != '\n'))
		    *(tgt ++) = *(ptr ++);
		*tgt = 0;
	    }
	    if (((parent == NULL) || !V_IS_ARR(parent))) {
		char	name[VAL_KEY_LEN];
		char	* tgt = name;

	        /* For now, just look for "name=": */
		if ((ptr = strstr((char *)blob_data(ctx->body), "name=\"")) == NULL) {
		    return HTTP_ERR_BAD_REQUEST;
		}
		ptr += 6;
		while ((tgt < (name + sizeof(name))) && (*ptr != '\0') && (*ptr != '"') && (*ptr != '\r') && (*ptr != '\n'))
		    *(tgt ++) = *(ptr ++);
		*tgt = 0;
		if ((node = val_new(name)) == NULL)
		    return HTTP_ERR_OUT_OF_MEMORY;
		if (ctx->request == NULL) {
		    if ((ctx->request = val_new(NULL)) == NULL)
			return HTTP_ERR_OUT_OF_MEMORY;
		}
		val_dict_add(ctx->request, node);
	    if (strstr((char *)blob_data(ctx->body), __http_content_type_str) != NULL) {
		if (strstr((char *)blob_data(ctx->body), __http_built_in_content_types[HTTP_TYPE_MULTIPART_MIXED]) != NULL) {
		    char	new_ct[512];
		    HTTP_ERROR_CODES	errn;

		    if (node == NULL)
			return HTTP_ERR_BAD_REQUEST;
		    strncpy(new_ct, (const char *)blob_data(ctx->body), sizeof(new_ct));
		    node->type = VAL_ARRAY;
		    blob_seek(ctx->body, cptr - (char *)blob_data(ctx->body), SEEK_CUR);
		    errn = parse_data_multipart(ctx, new_ct, node);
		    if (errn != HTTP_ERR_NONE)
			return errn;
		    node = NULL;
		    filename[0] = 0;
		    continue;
		}
	    }
		if (filename[0] != 0) {
		    val_t	* v;

		    node->type = VAL_ARRAY;
		    if ((v = val_new(filename)) == NULL)
			return HTTP_ERR_OUT_OF_MEMORY;
		    val_dict_add(node, v);
		    val_file(v, fs_tmp_name(NULL, NULL, 0), NULL);
		    node = v;
		}
	    } else {
		if (filename[0] == 0)
		    return HTTP_ERR_BAD_REQUEST;
		if ((node = val_new(filename)) == NULL)
		    return HTTP_ERR_OUT_OF_MEMORY;
		val_dict_add(parent, node);
		val_file(node, fs_tmp_name(NULL, NULL, 0), NULL);
	    }
	    blob_seek(ctx->body, cptr - (char *)blob_data(ctx->body), SEEK_CUR);
	}
    }
    return HTTP_ERR_BAD_REQUEST;
}

V2

/* Assume that ctx->ptr has adjusted to start of POST body and eof is set if whole request has been read already */
static HTTP_ERROR_CODES parse_data_multipart(HTTP_REQUEST * ctx, const char * content_type, val_t * parent) {
    char	* ptr, * cptr. * nptr, * tgt;
    BOOL	eof = FALSE;
    char	boundary[512], filename[512], name[512];
    val_t	* node = NULL;
    size_t	len;

    ctx->content_type = HTTP_TYPE_MULTIPART_FORM_DATA;
    /* Determine the boundary string: */
    if ((ptr = strstr(content_type, __http_bnd_str)) == NULL)
	return HTTP_ERR_NO_BOUNDARY;
    ptr += strlen(__http_bnd_str);
    while (*ptr == '"')
	ptr ++;
    memset((void *)boundary, 0, sizeof(boundary));
    strncpy(boundary, __http_lf, sizeof(boundary));
    strncpy(boundary + 2, __http_bnd, sizeof(boundary) - 2);
    cptr = boundary + strlen(__http_bnd)+ 2;
    while ((*ptr != '\0') && (*ptr != '\r') && (*ptr != '\n') && (*ptr != '"'))
	*(cptr ++) = *(ptr ++);
    log_info("Boundary - %s", boundary + 2);
    len = strlen(boundary);
    blob_seek(ctx->body, -2, SEEK_CUR);
    memcpy(blob_data(ctx->body), __http_lf, 2);
fprintf(stderr, "Got - %s\nLen %lu\n", (char *)blob_data(ctx->body), blob_len(ctx->body));
    /* Read in until there's no more: */
    while (TRUE) {

	cptr = http_feed_next_part(ctx, boundary, &eof);
	if (cptr == NULL) {
	    if (eof || !V_IS_FILE(node)) {
		if ((parent != NULL) && (parent != ctx->request))
		    val_free(parent);
		return HTTP_ERR_BAD_REQUEST;
	    }
	    fs_add_contents_simple(val_file_get_name(node), blob_data(ctx->body), blob_left(ctx->body));
	} else {
	    char	* ccd;

	    /* We got a boundary! */
	    if (node != NULL) {
		*cptr = 0;
		if (V_IS_FILE(node)) {
		    fs_add_contents_simple(val_file_get_name(node), blob_data(ctx->body), cptr - (char *)blob_data(ctx->body));
		} else {
		    ptr = url_decode(NULL, 0, (const char *)blob_data(ctx->body), strlen((const char *)blob_data(ctx->body)));
		    val_from_str(node, ptr);
		    ZFREE(ptr);
		}
		if (cptr[len+1] == '-') {
		    blob_seek(ctx->body , (cptr - (char *)blob_data(ctx->body)) + len + 2, SEEK_CUR);
		    /* We reach end of form! */
		    return HTTP_ERR_NONE;
		}
	    }
	    blob_seek(ctx->body , (cptr - (char *)blob_data(ctx->body)) + len + 2, SEEK_CUR);
	    if ((cptr = http_feed_next_part(ctx, __http_hdr_end, &eof)) == NULL) {
		return HTTP_ERR_BAD_REQUEST;
	    }
	    *cptr = 0;
	    cptr += 4; 
	    /* We should be at value or at included envelope at this moment */
	    /* We had just got a boundary, read headers: */
	    /* What kind of header is it? */
	    if ((ptr = strstr((char *)blob_data(ctx->body), __http_content_disp_str)) == NULL) {
		return HTTP_ERR_BAD_REQUEST;
	    }
	    ccd = ptr;
	    /* Content-disposition: */
	    filename[0] = 0;
	    name[0] = 0;
	    /* Check for filename field */
	    if ((ptr = strstr(ptr, "filename=\"")) != NULL) {
		ptr += 10;
	    } else {
		ptr = ccd;
		if ((ptr = strstr(ptr, "file=\"")) != NULL)
		    ptr += 6;
	    }
	    if (ptr != NULL) {
		tgt = filename;
		nptr = filename;
	    } else {
		tgt = name;
		nptr = name;

		/* For now, just look for "name=": */
		if ((ptr = strstr((char *)blob_data(ctx->body), "name=\"")) == NULL) {
		    return HTTP_ERR_BAD_REQUEST;
		}
		ptr += 6;
	    }
	    while ((tgt < (nptr + sizeof(name))) && (*ptr != '\0') && (*ptr != '"') && (*ptr != '\r') && (*ptr != '\n'))
		*(tgt ++) = *(ptr ++);
	    *tgt = 0;

	    if ((node = val_new(nptr)) == NULL)
		return HTTP_ERR_OUT_OF_MEMORY;
	    val_dict_add(parent, node);

	    if (strstr((char *)blob_data(ctx->body), __http_content_type_str) != NULL) {
		if (strstr((char *)blob_data(ctx->body), __http_built_in_content_types[HTTP_TYPE_MULTIPART_MIXED]) != NULL) {
		    char	new_ct[512];
		    HTTP_ERROR_CODES	errn;

		    strncpy(new_ct, (const char *)blob_data(ctx->body), sizeof(new_ct));
		    blob_seek(ctx->body, cptr - (char *)blob_data(ctx->body), SEEK_CUR);
		    if ((errn = parse_data_multipart(ctx, new_ct, node)) != HTTP_ERR_NONE)
			return errn;
		    node = NULL;
		    filename[0] = 0;
		    name[0] = 0;
		    continue;
		}
	    }
	    if (filename[0] != 0) {
		val_t	* v;

		node->type = VAL_ARRAY;
		if ((v = val_new(filename)) == NULL)
		    return HTTP_ERR_OUT_OF_MEMORY;
		val_dict_add(node, v);
		val_file(v, fs_tmp_name(NULL, NULL, 0), NULL);
		node = v;
	    }
	} else {
		if (filename[0] == 0)
		    return HTTP_ERR_BAD_REQUEST;
		if ((node = val_new(filename)) == NULL)
		    return HTTP_ERR_OUT_OF_MEMORY;
		val_dict_add(parent, node);
		val_file(node, fs_tmp_name(NULL, NULL, 0), NULL);
	    }
	    blob_seek(ctx->body, cptr - (char *)blob_data(ctx->body), SEEK_CUR);
	}
    }
    return HTTP_ERR_BAD_REQUEST;
}
