/*
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *	HTTP digest auth functions: originally imported from libmicrohttpd
 *
 *	Copyright (C) 2012-2014 PIVA SOFTWARE (www.pivasoftware.com)
 *		Author: Oussama Ghorbel <oussama.ghorbel@pivasoftware.com>
 *
 */


#ifndef CGI_H_
#define CGI_H_

#include <plib/http.h>

#ifndef CGI_HANDLER_TIMEOUT
#define CGI_HANDLER_TIMEOUT	180
#endif
#ifndef CGI_NICE
#define CGI_NICE 10
#endif /* CGI_NICE */
#ifndef CGI_PATH
#define CGI_PATH "/usr/local/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/sbin"
#endif /* CGI_PATH */
#ifndef CGI_LD_LIBRARY_PATH
#define CGI_LD_LIBRARY_PATH "/usr/local/lib:/usr/lib:/lib"
#endif /* CGI_LD_LIBRARY_PATH */

__BEGIN_DECLS

extern void do_cgi(HTTP_REQUEST *);
extern BOOL http_server_is_file_for_cgi(HTTP_REQUEST *, const char *);

__END_DECLS

#endif /* CGI_H_ */
