#include <plib/crypt.h>
#include "basicauth.h"

/**
 * make response to request authentication from the client
 *
 * @param fp
 * @param http_method
 * @param opaque string to user for opaque value
 * @return HTTP_ERROR_CODES
 */

HTTP_ERROR_CODES http_basic_auth_fail_response(HTTP_REQUEST * http) {
	char	header[1024];
	val_t	* val;
	struct http_server	* srv = http->app->localcfg;;
	const char	* realm = (SEMPTY(srv->auth_data.realm) ? srv->domain : srv->auth_data.realm);

	if ((val = val_new(__http_authen_str)) == NULL)
	    return HTTP_ERR_OUT_OF_MEMORY;

	/* Building the authentication header value */
	snprintf(header, sizeof(header),
		"Basic realm=\"%s\"", realm);
	if (!val_from_str(val, header)) {
	    val_free(val);
	    return HTTP_ERR_OUT_OF_MEMORY;
	}
	http_set_resp_header(http, val);
	return HTTP_ERR_NOT_AUTHORIZED;
}

/**
 * Authenticates the authorization header sent by the client
 *
 * @param http_method
 * @param url
 * @param header: pointer to the position just after the string "Authorization: Digest "
 * @param realm The realm presented to the client
 * @param username The username needs to be authenticated
 * @param password The password used in the authentication
 * @param nonce_timeout The amount of time for a nonce to be
 *			invalid in seconds
 * @return TRUE if authenticated, FALSE if not,
 *			FALSE if nonce is invalid
 */
BOOL http_basic_auth_check(HTTP_REQUEST * http, const char * header) {
	struct http_server	* srv = http->app->localcfg;;
	const char	* username = srv->auth_data.username, * password = srv->auth_data.password;
	char	* uname, * pwd;
	size_t	left;

	log_debug("header: %s", header);

	left = strlen(header);
	if (left <= 9) {
		log_err("Authentication failed: Invalid token length %lu", left);
		return FALSE;
	}
	header += 6;
	left -= 6;
	while ((*header != 0) && isspace(*header)) {
	    header ++;
	    left --;
	}
	if ((*header == 0) || (left <= 3)) {
		log_err("Authentication failed: Invalid token");
		return FALSE;
	}
	if ((uname = b64_decode(header)) == NULL) {
		log_err("Authentication failed: Could not allocate decoded string");
		return FALSE;
	}
	pwd = uname;
	while ((*pwd != 0) && (*pwd != ':'))
	    pwd ++;
	if (*pwd == 0) {
		log_err("Authentication failed: No password in the token");
		return FALSE;
	}
	* pwd = 0;
	pwd ++;
	if ((srv->auth_data.handler != NULL) && (srv->auth_data.data != NULL)) {
		PEER_ADDR	* remote = http->data;
		PEER_ADDR	* local = remote->parent;

		int	retcode = (*srv->auth_data.handler)(remote, local, uname, pwd, srv->auth_data.data);

		if (retcode >= 0)
			http->app->validated_level = retcode;
		else {
			log_err("Authentication failed: Could not authenticate (%s:%s) against external validator", uname, pwd);
			return FALSE;
		}
	} else {
		if (0 != strcmp(username, uname)) {
			log_err("Authentication failed: Invalid username (%s : %s).", username, uname);
			return FALSE;
		}
		if (0 != strcmp(password, pwd)) {
			log_err("Authentication failed: Invalid password (%s : %s).", password, pwd);
			return FALSE;
		}
	}
	return TRUE;
}
