#include "basicauth.h"
#include "digestauth.h"

#ifndef	HTTP_SRV_AUTH_TIMEOUT
#define	HTTP_SRV_AUTH_TIMEOUT	900
#endif

PLEX HTTP_ERROR_CODES http_server_check_auth(HTTP_REQUEST * http) {

    http->app->validated_level = 0;
    if (IS_BASIC_AUTH_REQUIRED(http->app)) {
	val_t	* val = http_find_val_in_req_header(http, __http_author_str);

	http->app->validated_level = -1;
	if (val != NULL) {
	    char	* ptr;
	    const char	* cptr = val_as_str_ptr(val);

	    if (!SEMPTY(cptr) && ((ptr = strstr(cptr, "Basic")) != NULL)) {
		if (http_basic_auth_check(http, ptr))
		    return HTTP_ERR_NONE;
		else
		    return HTTP_ERR_FORBIDDEN;
	    }
	}
	return http_basic_auth_fail_response(http);
    } else if (IS_DIGEST_AUTH_REQUIRED(http->app)) {
	val_t	* val = http_find_val_in_req_header(http, __http_author_str);

	http->app->validated_level = -1;
	if (val != NULL) {
	    char	* ptr;
	    const char	* cptr = val_as_str_ptr(val);

	    if (!SEMPTY(cptr) && ((ptr = strstr(cptr, "Digest")) != NULL)) {
		struct http_server	* srv = http->app->localcfg;
		int			ret = http_digest_auth_check(http, ptr, srv->auth_data.timeout);

		if (ret > 0)
		    return HTTP_ERR_NONE;
		else if (ret < 0)
		    return HTTP_ERR_FORBIDDEN;
	    }
	}
	return http_digest_auth_fail_response(http, NULL);
    }
    return HTTP_ERR_NONE;
}

PLEX BOOL http_server_add_auth(struct http_server * srv, WEB_APP_MODE mode, const char * realm, const char * username, const char * password, void * data, WEB_AUTH_METHOD handler, int timeout) {
    if (srv == NULL) {
	log_err("Wrong server param %p", srv);
	return FALSE;
    }
    if (mode & WEB_APP_AUTH_BASIC) {
	if (handler != NULL) {
	    if (data == NULL) {
		log_err("NULLified data to pass to authenticator");
		return FALSE;
	    }
	} else {
	    if (SEMPTY(username) || SEMPTY(password)) {
		log_err("Empty username (%s) or password (%s)", username, password);
		return FALSE;
	    }
	}
	srv->mode |= WEB_APP_AUTH_BASIC;
    } else if (mode & WEB_APP_AUTH_DIGEST) {
	if (SEMPTY(password)) {
	    log_err("Empty password is not allowed for Digest AUTH");
	    return FALSE;
	}
	if (handler != NULL) {
	    if (data == NULL) {
		log_err("NULLified data to pass to authenticator");
		return FALSE;
	    }
	} else {
	    if (SEMPTY(username)) {
		log_err("Empty username");
		return FALSE;
	    }
	}
	srv->mode |= WEB_APP_AUTH_DIGEST;
    } else {
	log_err("Wrong AUTH type");
	return FALSE;
    }
    if (timeout > 0)
	srv->auth_data.timeout = timeout;
    else
	srv->auth_data.timeout = HTTP_SRV_AUTH_TIMEOUT;
    srv->auth_data.data = data;
    srv->auth_data.handler = handler;
    strncpy(srv->auth_data.username, username, sizeof(srv->auth_data.username));
    strncpy(srv->auth_data.password, password, sizeof(srv->auth_data.password));
    if (!SEMPTY(realm))
	strncpy(srv->auth_data.realm, realm, sizeof(srv->auth_data.realm));
    return TRUE;
}
