#include <plib/fs.h>
#include "httpint.h"

char * http_feed_next_part(HTTP_REQUEST * ctx, const char * boundary, BOOL * eof) {
    char	* ptr = NULL;

    if (blob_offset(ctx->body) > 0) {
	size_t	remain = blob_offset(ctx->body);

	blob_rewind(ctx->body);
	blob_delete(ctx->body, NULL, remain);
	remain = blob_len(ctx->body);
	blob_skip(ctx->body, remain);
    }
    *((char *)blob_data(ctx->body)) = 0;
    while (!*eof && ((ptr = strstr((char *)blob_base(ctx->body), boundary)) == NULL) && (blob_size(ctx->body) > blob_offset(ctx->body))) {
	ssize_t	nread = http_read(ctx, blob_data(ctx->body), blob_size(ctx->body) - blob_offset(ctx->body));

	if (nread < 0) {
	    log_errno("Could not read any byte from socket %d", ctx->conn->fd);
	    *eof = TRUE;
	}
	if (nread == 0)
	    *eof = TRUE;
	if (!*eof && (blob_offset(ctx->body) == 0) && !isalnum((int)*((char *)blob_base(ctx->body))) && !isspace((int)*((char *)blob_base(ctx->body))))
	    *eof = TRUE;
	blob_len(ctx->body) += (size_t)nread;
	blob_skip(ctx->body, (size_t)nread);
	*((char *)blob_data(ctx->body)) = 0;
    }
    blob_rewind(ctx->body);
    return ptr;
}

PLEX ssize_t http_write(HTTP_REQUEST * ctx, const void * buf, size_t len) {
    if (IS_DEBUG_MODE(ctx->app))
	(void)write(STDERR_FILENO, buf, len);
    return pstream_write(ctx->conn, buf, len);
}

static inline ssize_t __http_printf_p(HTTP_REQUEST * ctx, const char * fmt, va_list lst) {
	char	buffer[BUFSIZ];
	ssize_t	res = 0;

	if ((res = vsnprintf(buffer, sizeof(buffer), fmt, lst)) > 0)
	    res = http_write(ctx, (const void *)buffer, (size_t)res);
	return res;
}

PLEX ssize_t http_printf(HTTP_REQUEST * ctx, const char * fmt, ...) {
	va_list	ap;
	ssize_t	res = -1;

	if ((ctx == NULL) || SEMPTY(fmt))
	    return res;
	va_start(ap, fmt);
	res = __http_printf_p(ctx, fmt, ap);
	va_end(ap);
	return res;
}

const char __http_head_end_fmt[] = "%s: %s; charset %s\r\n\r\n";

PLEX BOOL http_start_output(HTTP_REQUEST * ctx, const char * content_type, size_t cl) {
    char	buf[BUFSIZ], * ptr = buf;
    size_t	remain = sizeof(buf);
    ssize_t	written;

    if (ctx->form_headers != NULL) {
	written = ctx->form_headers(ctx, ptr, remain);
	ptr += written;
	remain -= written;
    } else {
	log_err("No 'send_headers' method specified");
	return FALSE;
    }
    if (cl > 0) {
	written = snprintf(ptr, remain, "%s: %lu\r\n", __http_content_len_str, (unsigned long)cl);
	ptr += written;
	remain -= written;
	if (SEMPTY(content_type)) {
	    written = snprintf(ptr, remain, __http_head_end_fmt, __http_content_type_str, "text/html", web_get_charset(ctx->app));
	    remain -= written;
	    ptr += written;
	} else {
	    written = snprintf(ptr, remain, "%s: ", __http_content_type_str);
	    remain -= written;
	    ptr += written;
	    written = snprintf(ptr, remain, content_type, web_get_charset(ctx->app));
	    remain -= written;
	    ptr += written;
	    written = snprintf(ptr, remain, "\r\n\r\n");
	    remain -= written;
	    ptr += written;
	}
    }
    if (ptr > buf)
	return (BOOL)(http_write(ctx, buf, (size_t)(ptr - buf)) == (ssize_t)(ptr - buf));
    return FALSE;
}

PLEX BOOL http_write_file(HTTP_REQUEST * ctx, const char * filename, BOOL cl) {
    BOOL	res = FALSE;
    off_t	offset = 0;
    int64_t	sz = fs_size(filename, FALSE);

    if (sz < 0) {
	log_err("Could not get size for file %s", filename);
	return res;
    }
    if (!pstream_set_filename(ctx->conn, filename)) {
	log_err("Could not set stream target to %s", filename);
	return res;
    }
    if (cl) {
	const char	* ct = http_get_mime_type(filename, NULL, 0);

	http_start_output(ctx, ((ct == NULL) ? __http_built_in_content_types[HTTP_TYPE_TEXT_PLAIN] : ct), (size_t)sz);
    }
    res = (BOOL)(pstream_send_file(ctx->conn, offset, (size_t)sz) == (ssize_t)sz);
    return res;
}

void http_read_garbage(HTTP_REQUEST * http) {
	char	buf[2];

	if (!IS_REQ_SSL_MODE(http))
		(void)sock_read(http->conn->fd, buf, sizeof(buf), 10); /* Read two more bytes from incorrect clients to prevent TCP reset */
}
