#include <plib/httpclient.h>

PLEX BOOL http_client_download_file(const char * url, const char * filename) {
    WEB_CONTEXT	* app;
    pstream_t	* stream;

    if (SEMPTY(url) || SEMPTY(filename)) {
	log_err("Wrong params: %s -> %s", url, filename);
	return FALSE;
    }
    if ((stream = pstream_init(filename, -1, NULL, 0)) == NULL) {
	log_err("Could not init stream for %s", filename);
	return FALSE;
    }

    if ((app = http_client_get(url, NULL, NULL, 0, stream, NULL, NULL, -1)) != NULL) {
	web_cleanup_ctx(app);
	return TRUE;
    } else {
	log_err("Could not init HTTP client for %s", url);
    }
    if (stream != NULL) {
	pstream_close(stream);
	ZFREE(stream);
    }
    return FALSE;
}

PLEX BOOL http_client_delete_file(const char * url, const char * filename) {
    WEB_CONTEXT	* app;

    if (SEMPTY(url) || SEMPTY(filename)) {
	log_err("Wrong params: %s -> %s", url, filename);
	return FALSE;
    }

    if ((app = http_client_request(url, NULL, NULL, WEB_CLIENT_OPT_DEL, NULL, NULL, NULL, -1)) != NULL) {
	web_cleanup_ctx(app);
	return TRUE;
    } else {
	log_err("Could not init HTTP client for %s", url);
    }
    return FALSE;
}
