#include <plib/httpserver.h>
#include <plib/exec.h>
#include "../../http/server/shell/webapp.h"
#include "../../http/server/shell/launcher.h"

static blob_t * read_and_write(HTTP_REQUEST * http, struct Session * session) {
	ssize_t	nc;
	blob_t	* blob = blob_new();

	if (blob == NULL)
	    return NULL;
	nc = sock_read_to_blob(session->pty, blob);
	if (nc > 0) {
	    char	* result;

	    blob_rewind(blob);
	    if ((result = json_escape((const char *)blob_data(blob), (size_t)nc)) != NULL) {
		blob_printf(blob, "{\"session\":\"%s\",\"data\":\"%s\"}", session->sessionKey, result);
		ZFREE(result);
		session->last_time = time(NULL);
		goto out;
	    }
	} else if (nc < 0) {
	    blob_free(blob);
	    blob = NULL;
	    goto out;
	}
	blob_printf(blob, "{\"session\":\"%s\"}", session->sessionKey);
out:
	os_mutex_unlock(&session->mutex);
	return blob;
}

static BOOL exec(HTTP_REQUEST * http) {
    BOOL			res = FALSE, sessionIsNew;
    val_t			* val;
    char			* sessionKey = NULL, * peerName = NULL, * keys = NULL, * rootUrl = NULL, * keyCodes = NULL;
    struct shell_in_a_box_data	* data;
    int				oldWidth, oldHeight;
    struct Session		* session;
    blob_t			* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->method != HTTP_REQ_POST))
	return res;

    http->flags |= HTTP_FLAG_CLOSE_CONNECTION;
    peerName = http_get_peername(http);
    data = getShellHashMap(http->app->localcfg);
    if (data == NULL) {
	goto out;
    }
    if ((val = dict_find_node_near(http->request, "session", TRUE)) != NULL) {
	if ((sessionKey = val_as_str_simple(val)) == NULL)
	    goto out;
    }
    session = findSession(data, sessionKey, peerName, &sessionIsNew);
    if (session == NULL)
	goto out;

    oldWidth = session->width;
    oldHeight = session->height;
    if ((val = dict_find_node_near(http->request, "width", TRUE)) != NULL) {
	int64_t	t;
	val_as_int(val, &t);
	session->width = (int)t;
    }
    if ((val = dict_find_node_near(http->request, "height", TRUE)) != NULL) {
	int64_t	t;

	val_as_int(val, &t);
	session->height = (int)t;
    }
    if ((val = dict_find_node_near(http->request, "keys", TRUE)) != NULL) {
	keys = val_as_str_simple(val);
    }
    if ((val = dict_find_node_near(http->request, "rooturl", TRUE)) != NULL)
	rootUrl = val_as_str_simple(val);

    // Create a new session, if the client did not provide an existing one
    if (sessionIsNew) {
	if (keys) {
	    abandonSession(data, session);
	    goto out;
	}
//	if (launchChild(service->id, session,
//                    rootUrl && *rootUrl ? rootUrl : urlGetURL(url)) < 0) {
	if (launchChild(data, 0, session,
                    rootUrl) < 0) {
log_err("Could not launch child");
	    abandonSession(data, session);
	    goto out;
	}
    }
    // Reset window dimensions of the pseudo TTY, if changed since last time set.
    if ((session->width > 0) && (session->height > 0) && ((session->width != oldWidth) || (session->height != oldHeight))) {
	log_debug("[server] Window size changed to %dx%d", session->width, session->height);
	setWindowSize(session->pty, session->width, session->height);
    }

    // Process keypresses, if any. Then send a synchronous reply.
    if (!SEMPTY(keys)) {
	ssize_t	len = 0;

	if ((keyCodes = ZALLOC(strlen(keys)/2)) == NULL) {
	    abandonSession(data, session);
	    goto out;
	}
	for (const unsigned char *ptr = (const unsigned char *)keys; ;) {
	    unsigned	c0 = *ptr++, c1;

	    if (c0 < '0' || (c0 > '9' && c0 < 'A') || (c0 > 'F' && c0 < 'a') || c0 > 'f')
		break;
	    c1 = *ptr++;
	    if (c1 < '0' || (c1 > '9' && c1 < 'A') || (c1 > 'F' && c1 < 'a') || c1 > 'f')
		break;
	    keyCodes[len++] = 16*((c0 & 0xF) + 9*(c0 > '9')) + (c1 & 0xF) + 9*(c1 > '9');
	}
	if (sock_write(session->pty, keyCodes, len, 100) != len) {
log_err("Could not write all bytes to child process");
	    abandonSession(data, session);
	    goto out;
	}
    }
    blob = read_and_write(http, session);
    if (blob != NULL) {
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free(blob);
    }
out:
    ZFREE(peerName);
    ZFREE(keys);
    ZFREE(keyCodes);
    ZFREE(rootUrl);
    return res;
}

DECLARE_PLUGIN(shell)
PLUGIN_METHOD(exec)
END_PLUGIN(shell)
