#include <plib/httpserver.h>
#include "remotectrl.h"

static blob_t * hsc_user_list(short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = get_user_list( &srv);
	rmtctrl_close( &srv);
    }
    return b;
}

static blob_t * hsc_user_stat_by_mac(const char * mac, short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = get_user_stat_by_mac( &srv, mac);
	rmtctrl_close( &srv);
    }
    return b;
}

static blob_t * hsc_user_stat_by_ip(const char * ip, short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = get_user_stat_by_ip( &srv, ip);
	rmtctrl_close( &srv);
    }
    return b;
}

static blob_t * hsc_user_auth_by_mac(const char * mac, short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = auth_user_by_mac( &srv, mac);
	rmtctrl_close( &srv);
    }
    return b;
}

static blob_t * hsc_user_auth_by_ip(const char * ip, short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = auth_user_by_ip( &srv, ip);
	rmtctrl_close( &srv);
    }
    return b;
}

static blob_t * hsc_user_drop_by_mac(const char * mac, short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = disconnect_user_by_mac( &srv, mac);
	rmtctrl_close( &srv);
    }
    return b;
}

static blob_t * hsc_user_drop_by_ip(const char * ip, short port) {
    blob_t * b = NULL;
    struct rmt_socket_t	srv;

    if ( rmtctrl_open_client( &srv, port)) {
	b = disconnect_user_by_ip( &srv, ip);
	rmtctrl_close( &srv);
    }
    return b;
}

static BOOL user_list(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    blob_t	* blob = NULL;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((blob = hsc_user_list(3991)) != NULL) {
	res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
	blob_free( blob);
    }
    return res;
}

static BOOL user_sbm(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "mac")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob = NULL;

	    if ((blob = hsc_user_stat_by_mac( ptr, 3991)) != NULL) {
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL user_sbip(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "ip")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob = NULL;

	    if ((blob = hsc_user_stat_by_ip( ptr, 3991)) != NULL) {
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL user_abm(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "mac")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if ( ptr != NULL) {
	    blob_t	* blob = NULL;

	    if ((blob = hsc_user_auth_by_mac( ptr, 3991)) != NULL) {
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL user_abip(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((dict_find_node(http->request, "ip")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob = NULL;

	    if ((blob = hsc_user_auth_by_ip( ptr, 3991)) != NULL) {
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL user_dbm(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((node = dict_find_node(http->request, "mac")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob = NULL;

	    if ((blob = hsc_user_drop_by_mac( ptr, 3991)) != NULL) {
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

static BOOL user_dbip(HTTP_REQUEST * http) {
    BOOL	res = FALSE;
    val_t	* node;

    if ((http == NULL) || (http->app == NULL) || (http->app->validated_level <= 0))
	return res;

    if ((dict_find_node(http->request, "ip")) != NULL) {
	char * ptr = val_as_str_simple(node);

	if (ptr != NULL) {
	    blob_t	* blob = NULL;

	    if ((blob = hsc_user_drop_by_ip( ptr, 3991)) != NULL) {
		res = http_write_body_blob(http, __http_built_in_content_types[HTTP_TYPE_APPLICATION_JSON], blob);
		blob_free( blob);
	    }
	    ZFREE( ptr);
	}
    }
    return res;
}

DECLARE_PLUGIN(hsc)
PLUGIN_METHOD(user_list)
PLUGIN_METHOD(user_sbm)
PLUGIN_METHOD(user_abm)
PLUGIN_METHOD(user_dbm)
PLUGIN_METHOD(user_sbip)
PLUGIN_METHOD(user_abip)
PLUGIN_METHOD(user_dbip)
END_PLUGIN(hsc)
