#include <plib/curl/pcurl.h>

static void usage(const char * progname) {
    fprintf(stderr, "Usage: %s URL [FILENAME [BANDWIDTH]]\n", progname);
    exit(-1);
}

int main(int argc, char ** argv) {
    const char	* ptr;
    int		ret = 0, bw = 0, cmd = 0; /* Assume GET */
    struct uri_t * uri = NULL;

    if (argc < 2)
	usage(argv[0]);

    if (strstr(argv[0], "put") != NULL) {
	cmd = 1;
	if (argc < 3)
	    usage(argv[0]);
    }
    if (argc > 3)
	bw = atoi(argv[3]);
    if (argc > 2) {
	ptr = argv[2];
    } else {
	if ((uri = uri_parse(argv[1])) == NULL) {
	    log_err("Could not parse URI %s", argv[1]);
	    return -1;
	}
	if (SEMPTY(uri->uri_filename)) {
	    log_err("Could not get filename from URI %s to save file as. Specify filename to save exactly", argv[1]);
	    ret = -2;
	    goto mend;
	}
	ptr = uri->uri_filename;
    }
    if (cmd == 0) {
	if (!download_file(argv[1], ptr, bw))
	    ret = 1;
    } else {
	if (!upload_file(argv[1], ptr, bw))
	    ret = 1;
    }
mend:
    if (uri != NULL)
	uri_destroy(uri);
    return ret;
}
