#ifndef P_HTTPCLIENT_H
#define P_HTTPCLIENT_H

#include <plib/http.h>

#define	HTTP_MAX_REDIRECTS	8

typedef enum {
    WEB_CLIENT_OPT_POST = 0x1,
    WEB_CLIENT_OPT_PUT = 0x2,
    WEB_CLIENT_OPT_DEL = 0x4,
    WEB_CLIENT_OPT_OPTIONS = 0x8,
    WEB_CLIENT_OPT_TRACE = 0x10,
    WEB_CLIENT_OPT_HTTP10 = 0x20,
    WEB_CLIENT_OPT_DEBUG = 0x40,
    WEB_CLIENT_OPT_SSL_VERIFY = 0x80
} WEB_CLIENT_OPTIONS;

__BEGIN_DECLS

PLEX WEB_CONTEXT * http_client_request(const char *, const val_t *, const val_t *, WEB_CLIENT_OPTIONS, 
				pstream_t *, const char *, const char *, int);
#define	http_client_get(u, h, r, o, s, ua, c, ct)	http_client_request(u, h, r, ((o) & (~WEB_CLIENT_OPT_POST)), s, ua, c, ct)
#define	http_client_post(u, h, r, o, s, ua, c, ct)	http_client_request(u, h, r, ((o) | WEB_CLIENT_OPT_POST), s, ua, c, ct)

PLEX BOOL http_client_download_file(const char *, const char *);
PLEX BOOL http_client_delete_file(const char *, const char *);

__END_DECLS

#endif
